<?php


namespace App\Exports;
use Auth;
use App\Models\Product;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
    
    
class ExportLearningModule implements FromCollection, WithHeadings
{
 
     public function collection()
    {
        if(Auth::user()->type == config('global.LEARNING_PARTNER')){
            return Product::leftJoin('users','users.id','=','products.company_id')->where('products.company_id',Auth::user()->id)->where('products.is_deleted',0)
                ->select('users.name as companyName','products.name','products.cost','products.description')->get();
        }else if(Auth::user()->type == config('global.VENDOR')){
            $course_ids = explode(',', Auth::user()->course_id);
            return Product::leftJoin('users','users.id','=','products.company_id')->whereIn('products.id', $course_ids)->where('products.is_deleted',0)
                ->select('users.name as companyName','products.name','products.cost','products.description')->get();
        }else{
            return Product::leftJoin('users','users.id','=','products.company_id')->where('products.is_deleted',0)
                ->select('users.name as companyName','products.name','products.cost','products.description')->get();
        }
        

    }
    
    public function headings() :array
    {
        return["Company Name", "Product Name","Examination Cost","Description"];
    }
}