<?php


namespace App\Exports;
use Auth;
use App\Models\User;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
    
    
class ExportUser implements FromCollection, WithHeadings
{
 
    protected $type;
    public function __construct($type)
    {
      
        $this->type = $type;
    }
     public function collection()
    {
      
         $userDatas =  User::where('type',config('global.USER'))->where('is_deleted',0)->select('name','email','email','phone_number')->get();
         if(!empty($userDatas)){
             $result = array();
               foreach($userDatas as $userData){
                   $result[] = array(
                      'name'=>$userData->name,
                      'type' => "Direct",
                      'email' => $userData->email,
                      'mobile' => $userData->phone_number
                   );
                }
        
                return collect($result);
         }
      
        

    }
    
    public function headings() :array
    {
        return["User Name","Vendor Name/User Type", "Email","Mobile"];
    }
}