<?php
namespace App\Exports;

use App\Models\Order; // Import your Order model
use Illuminate\Contracts\View\View;
use Maatwebsite\Excel\Concerns\FromView;

class OrderInvoiceExport implements FromView
{
    protected $order;

    public function __construct(Order $order)
    {
        $this->order = $order;
    }

    public function view(): View
    {
        return view('exports.invoice', ['orders' => $this->order]);
    }
}
