<?php
  use App\Models\Product;
  use App\Models\Brand;
    use App\Models\Cart;
  function random_code(){
 
    return rand(1111, 9999);
  }


function GetSubCategoryName($id = Null){

    $data = App\Models\Subcategory::where('id',$id)->first();
    if(isset( $data)){
         $data = App\Models\Subcategory::where('id',$id ?? Null)->first()->sub_name;
         return $data;
    }else{
        return false;
    }

   

}

function getAllSliderData(){
    $data = App\Models\Slider::where('status',1)->where('banner_for','desktop')->get();   
    return $data;
}

function getBannerData($slug = NULL){
    $data = App\Models\Banner::where('slug',$slug)->first();   
    return $data->image;
}

 function wishlist_status($id) {
    if (Auth::user()) {
        $customer = Auth::user();
        $wishlist = App\Models\Wishlist::where('user_id',$customer->id)->where('product_id',$id)->first();
        if($wishlist) {
            return true;
        } else {
            return false;
        }
    } else {
        return false;
    }
}

function getCartCount(){
    $cartItems = 0;
     if (Auth::check()) {
        // If the user is logged in, fetch the cart items associated with their user ID
        $cartItems = Cart::with('product')
            ->where('user_id', Auth::id())
            ->count();
    } else {
        // If the user is not logged in, fetch the cart items associated with the cart identifier cookie
        $cartIdentifier = request()->cookie('cart_identifier');
        if ($cartIdentifier) {
            $cartItems = Cart::with('product')
                ->where('random_id', $cartIdentifier)
                ->count();
        }
    }
    return $cartItems;
}

function getCartItems(){
    $cartItems = [];

    // Check if the user is logged in
    if (Auth::check()) {
        // If the user is logged in, fetch the cart items associated with their user ID
        $cartItems = Cart::with('product')
            ->where('user_id', Auth::id())
            ->get();
    } else {
        // If the user is not logged in, fetch the cart items associated with the cart identifier cookie
        $cartIdentifier = request()->cookie('cart_identifier');
        if ($cartIdentifier) {
            $cartItems = Cart::with('product')
                ->where('random_id', $cartIdentifier)
                ->get();
        }
    }
    return $cartItems;
}


    function showFeed()
    {
        $accessToken = 'IGQWRNR3BmSFYxYWswa1VDT0RPZAXdDaEM1aEY1WWpGbjlXZATRmc3hrQ3JTWGdDenhtR3ozSHgxdVNZAWmZAtR0VZAcEpVNGVZASDB0eWNLQnpmRW42emFLaW0wUDBPUElOVXVjRUo4MGdWWGhYVlRnRkZAqU1VPYlZAIV0UZD';
        $response = Http::get("https://graph.instagram.com/me/media?fields=id,caption,media_type,media_url,thumbnail_url,permalink,timestamp&access_token=$accessToken");

        $feedData = $response->json();
        dd($feedData);
        return $feedData;
    }
            


function countProductsBySubcategories($id = Null){

    $data = App\Models\Product::where('sub_cat_id',$id ?? Null)->count();
    if(isset( $data)){
         return $data;
    }else{
         return 0;
    }
}



function countProductsByChildSubcategories($id = Null){

    $data = App\Models\Product::where('child_sub_cat_id',$id ?? Null)->count();
    if(isset( $data)){
         return $data;
    }else{
         return 0;
    }
}

function getProductsSize($id = Null){

    $data = App\Models\Size::where('id',$id ?? Null)->first();
    if(isset( $data)){
           $data = App\Models\Size::where('id',$id ?? Null)->first()->size_name;
         return $data;
    }else{
         return 0;
    }
}


function getAllColors(){
    $data = App\Models\Color::get();   
    return $data;
}


function getAllSizes(){
    $data = App\Models\Size::get();   
    return $data;
}



function getAllFabric(){
    $data = App\Models\Fabric::get();   
    return $data;
}

 function selectedSlug()
{
    $currentUrl = url()->current();
    $path = parse_url($currentUrl, PHP_URL_PATH);

// Get the last part of the path using basename
$selectedUrlEnd = basename($path);

    return $selectedUrlEnd;
}


function getProductsColor($id = Null){

     $data = App\Models\Color::where('id',$id ?? Null)->first();
    if(isset( $data)){
      $data = App\Models\Color::where('id',$id ?? Null)->first()->color_name;
         return $data;
    }else{
         return 0;
    }
}

function getProductsColorCode($id = Null){

     $data = App\Models\Color::where('id',$id ?? Null)->first();
    if(isset( $data)){
      $data = App\Models\Color::where('id',$id ?? Null)->first()->color_code;
         return $data;
    }else{
         return 0;
    }
}

 function CountWishlist() {
            if (Auth::user()) {
                 $customer = Auth::user();
                $wishlist = App\Models\Wishlist::where('user_id',$customer->id)->count();
                if($wishlist) {
                    return  $wishlist;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        }

function CountProductRating($product_id) {
            
               
                $reviews = App\Models\ProductReview::where('product_id',$product_id)->count();
                if($reviews) {
                    return  $reviews;
                } else {
                    return false;
                }
          
        }
function GetProductAvgRating($product_id) {
            
               
                $reviews = App\Models\ProductReview::where('product_id',$product_id)->avg('rating');
                if($reviews) {
                    return  round($reviews);
                } else {
                    return false;
                }
          
        }
function SortBy(){

    $array  = array(   
        "new_collection" => "New Collection",
        "top_selling" => "Top Selling",
        "top_rated" => "Top Rated"
      
    );

    return $array;

}


function getAllCategory(){
    $category = App\Models\Category::where('status','1')->get();
                if($category) {
                    return  $category;
                } else {
                    return false;
                }

}



function getAllCategoryBanner(){
    $category = App\Models\Banner::where('status','1')->where('type','category')->get();
                if($category) {
                    return  $category;
                } else {
                    return false;
                }

}

function getAllCategoryProduct($catId = 0){
    echo 877;
        $products = Product::join('product_sizes', 'products.id', '=', 'product_sizes.product_id')
            ->where('products.status', 1)
            ->select('products.id', 'products.name', 'products.front_image', 'products.hover_image', DB::raw('MIN(product_sizes.sell_price) as sell_price'))
            ->groupBy('products.id')
            ->where('category_id',$catId)
            ->limit(4) // Limit the results to the first 4 products
            ->get();
           // echo '<pre/>';print_r(count($products));
            return $products;
}


function getAllSubCategory($catId = 0){

    $subcategory = App\Models\Subcategory::where('cat_id',$catId)->where('sub_status','active')->get();
                if($subcategory) {
                    return  $subcategory;
                } else {
                    return false;
                }

}

function getPrice($productId){
     $productData =    Product::where('id',$productId)->first();
    // echo '<pre/>';print_r($productId);die;
     $getGoldRate =  Brand::where('bd_name','Gold')->value('bd_price');
     
     
     if($productData->product_type == 'gold'){
         if($productData->gold_type == 14){
             $goldRate = ($getGoldRate/ 22) * 14;
         }else if($productData->gold_type == 18){
             $goldRate = ($getGoldRate/ 22) * 18;
         }else if($productData->gold_type == 22){
             $goldRate = $getGoldRate;
         }
         $totalPrice = ($goldRate * (float)$productData->gram) + $productData->diamond + $productData->making_charges;
         $gst =  ($totalPrice * 3) /100;
        return $totalPrice + $gst;
     }else{
         return $productData->pro_actual_price;
     }
     
}



