<?php
   
namespace App\Http\Controllers\API;
   
use Illuminate\Http\Request;
use App\Http\Controllers\API\BaseController as BaseController;
use App\Models\User;
use App\Models\Category;
use App\Models\Product;
use App\Models\ProductColor;
use App\Models\ProductSize;
use App\Models\Banner;
use App\Models\Subcategory;
use App\Models\Wishlist;
use App\Models\ComingSoon;
use Illuminate\Support\Facades\Auth;
use Validator;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;
   
   
class ProductController extends BaseController
{
   
    
    public function getAllCategory(Request $request){
     
           $categories = Category::where('status',1)->select('categories.name','categories.id','categories.image')->orderBy('sort_order','asc')->get();
        
           if($categories){
               return $this->sendResponse($categories, 'Category list');
           }else{
               return $this->sendError('Category Not Exist In Database.');
           }
       
    }
    
    public function getAllSubCategory(Request $request,$categoryId=0){
     
           $subcategories = Subcategory::where('status',1)->where('cat_id',$categoryId)->select('subcategories.*')->orderBy('id','desc')->get();
        
           if($subcategories){
               return $this->sendResponse($subcategories, 'Sub Category list');
           }else{
               return $this->sendError('Category Not Exist In Database.');
           }
       
    }
    
    
    public function getAllCategoryWithBanner(Request $request){
     
           $categories = Category::where('status',1)->orderBy('sort_order','asc')->get();
           if($categories){
               return $this->sendResponse($categories, 'Category list');
           }else{
               return $this->sendError('Category Not Exist In Database.');
           }
       
    }
    
    
    public function getAllRelatedProduct(Request $request,$sub_cat_id = 0){
     
           $products = Product::where('products.sub_category_id',$sub_cat_id)->select('products.*')->limit(12)->orderBy('id','desc')->get();
           if(!empty($products)){
              foreach($products as $productData){
                  $sizeData = ProductSize::where('product_id',$productData->id)->orderBy('id','asc')->first();
                  $productData->price = $sizeData->price;
                  $productData->sell_price = $sizeData->sell_price;
              }
               return $this->sendResponse($products, 'Related Product list');
           }else{
               return $this->sendError('Category Not Exist In Database.');
           }
       
    }
    
    
      public function getAllProduct(Request $request){
          // $user_id = $request->user()->id;
          $products = Product::leftJoin('product_sizes','product_sizes.product_id','=','products.id')
          ->select('products.*',DB::raw('MIN(product_sizes.sell_price) as sell_price'));
          if(isset($request->name) && !empty($request->name)){
                  $products=$products->where('products.name','LIKE','%'.$request->name.'%');
             } 
             if(isset($request->category_id) && !empty($request->category_id)){
                  $products=$products->where('products.category_id',$request->category_id);
             } 
             
             if(isset($request->fabric_id) && !empty($request->fabric_id)){
                  $products=$products->where('products.fabric_id',$request->fabric_id);
             } 
             
              if(isset($request->banner_slug) && !empty($request->banner_slug)){
                  if($request->banner_slug == 'new'){
                      $products=$products->where('products.is_new',1);
                  }else if($request->banner_slug == 'black'){
                        $products=$products->where('products.blackdress',1);
                  }else{
                        $products=$products->where('products.party_wear',1);
                  }
                  
             } 
          
          
         
             if(isset($request->size_id) && !empty($request->size_id)){
                  $products=$products->where('product_sizes.size_id',$request->size_id);
             } 
          
          
            if((isset($request->min_price) && !empty($request->min_price)) && (isset($request->max_price) && !empty($request->max_price))){
                  $products=$products->whereBetween('product_sizes.price', [$request->min_price, $request->max_price]);
            } 
            
            
            if(isset($request->sort_by) && !empty($request->sort_by)){
                if($request->sort_by == 'low_to_high'){
                    $products=$products->orderBy('sell_price', 'asc');
                }else if($request->sort_by == 'high_to_low'){
                    $products=$products->orderBy('sell_price', 'desc');
                }else if($request->sort_by == 'newest'){
                    $products=$products->orderBy('id', 'desc');
                }    
                 
            } 
          
          
           
          $products = $products->groupBy("products.id")->orderBy('id','desc')->get();
          if(!empty($products)){
              foreach($products as $productData){
                  $sizeData = ProductSize::where('product_id',$productData->id)->orderBy('id','asc')->first();
                  $productData->price = $sizeData->price;
                  $productData->sell_price = $sizeData->sell_price;
                  
                  $isWislist  = Wishlist::where('product_id',$productData->id);
                  if(!empty($request->user_id)){
                      $isWislist = $isWislist->where('user_id',$request->user_id);
                  }else{
                     $isWislist = $isWislist->where('random_id',$request->random_id);
                  }
                  $isWislist = $isWislist->first();
                  if(!empty($isWislist)){
                      $productData->is_wishlist = 1;
                  }else{
                      $productData->is_wishlist = 0;
                  }
                  
              }
              return $this->sendResponse($products, 'Product list');
          }else{
              return $this->sendError('Category Not Exist In Database.');
          }
       
    }
    
    


    
    
     public function getProductDetail(Request $request,$id = 0){
            //$user_id = $request->user()->id;
          $products = Product::with('productSizes')->where('id',$id)->first();
          if(!empty($products)){
                
              return $this->sendResponse($products, 'Product Detail');
          }else{
              return $this->sendError('Category Not Exist In Database.');
          }
       
    }
    
// public function getProductDetail(Request $request, $id = 0)
// {
//     $product = Product::with(['sizes', 'productSizes' => function ($query) {
//         $query->select('id', 'product_id', 'product_size_id', 'price');
//     }])->where('id', $id)->first();

//     if (!empty($product)) {
//         return $this->sendResponse($product, 'Product Detail');
//     } else {
//         return $this->sendError('Product Not Found in Database.');
//     }
// }


    
    
     public function notifyMe(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'product_id' => 'required',
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        
  
   
        $input = $request->all();
       
        $notify = new ComingSoon();
        $notify->email = $input['email'];
        $notify->name = $input['name'];
        $notify->phone_number = $input['phone_number'];
        $notify->product_id = $input['product_id'];
        $notify->save();
   
        return $this->sendResponse($notify, 'Data Added Successfully.');
    }
    
    
}