<?php
   
namespace App\Http\Controllers\API;
   
use Illuminate\Http\Request;
use App\Http\Controllers\Traits\CommonFunctionsTrait;
use App\Http\Controllers\API\BaseController as BaseController;
use App\Models\User;
use App\Models\Booking;
use App\Models\UserAddress;
use App\Models\Review;
use App\Models\Product;
use App\Models\Order;
use App\Models\Cart;
use App\Models\Wishlist;
use App\Models\ProductColor;
use App\Models\ProductSize;
use App\Models\Notification;
use App\Models\OrderDetail;
use App\Models\Coupon;
use App\Models\Reel;
use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use DB;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;


   
class UserController extends BaseController
{
    use CommonFunctionsTrait;
    
    protected $httpClient;

    public function __construct(Client $httpClient)
    {
        $this->httpClient = $httpClient;
    }
    
    public function changePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'current_password' => ['required', new MatchOldPassword],
            'new_password' => ['required'],
            'new_confirm_password' => ['same:new_password'],
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
   
       User::find($request->user()->id)->update(['password'=> Hash::make($request->new_password)]);
        return $this->sendResponse([],'Your Password updated successfully');
    }
    
    
   public function userDetail(Request $request)
    {
        $userDetail = User::where('id', $request->user()->id)
            ->select('id', 'name', 'email','image', 'phone_number', 'created_at', 'updated_at')
            ->first();

        return response()->json($userDetail);
    }
    
    
     public function getTotalAmount(Request $request)
    {
        $user_id = $request->user()->id;
    
        $totalAmount = Cart::where('user_id', $user_id)->sum('amount');
    
        if ($totalAmount > 0) {
            return $this->sendResponse(['total_amount' => $totalAmount], 'Total Amount from Cart');
        } else {
            return $this->sendError('Your Cart is Empty.');
        }
    }


   public function updateUserProfile(Request $request)
{
    $id = $request->user()->id;
    $data = User::find($id);
    $request->validate([
        'email' => 'unique:users,email,' . $id,
        'phone_number' => 'unique:users,phone_number,' . $id,
    ]);

    if (!empty($request->phone_number)) {
        $data->phone_number = $request->phone_number;
    }
    if (!empty($request->name)) {
        $data->name = $request->name;
    }
    if (!empty($request->email)) {
        $data->email = $request->email;
    }
    if ($data->save()) {
        return response()->json([
            'success' => true,
            'message' => 'Your Profile updated successfully',
        ], 200);
    }

    return response()->json([
        'success' => false,
        'message' => 'User not added',
    ], 200);
}

    
    
    


    public function updateUserImage(Request $request)
    {
        $id = $request->user()->id;
        $data = User::find($id);
        $image = $request->file('image');
    
        if (isset($image) && !empty($image)) {
            $imageName = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/user');
            $image->move($destinationPath, $imageName);
            $imagePath = 'public/uploads/user/'.$imageName;
            $data->image = $imagePath;
    
            if ($data->save()) {
                return response()->json([
                    'success' => true,
                    'message' => 'Your image updated successfully',
                ], 200);
            }
        }
        return response()->json([
            'success' => false,
            'message' => 'User not added',
        ], 200);
    }

    
    
    
    
     public function addUserAddress(Request $request){
        $data = new UserAddress();
        $data->user_id = $request->user()->id;
        if($request->default_address == 1){
            $getAlreadyDefaultAddress = UserAddress::where('user_id',$request->user()->id)->where('default_address',1)->first();
            if(!empty($getAlreadyDefaultAddress)){
                 $getAlreadyDefaultAddress->default_address = 0;
                $getAlreadyDefaultAddress->save();
            }
           
        }
        $data->name = $request->name;
        $data->mobile = $request->mobile;
        $data->address_type = $request->address_type;
        $data->country_id = $request->country_id;
        $data->state_id = $request->state_id;
        $data->city_id = $request->city_id;
        $data->pin_code = $request->pin_code;
        $data->address = $request->address;
        $data->locality = $request->locality;
        // $data->default_address = $request->default_address;
        if($data->save()){
            return $this->sendResponse($data,'User Address Added Successfully');
        }else{
            return $this->sendError('User not added');
        }
    }
    
    /**
     * List All Address api
     *
     * @return \Illuminate\Http\Response
     */
    
    public function getAllUserAddress(Request $request)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $addressData  = UserAddress::leftJoin('countries','countries.id','=','user_addresses.country_id')
                                        ->leftJoin('states','states.id','=','user_addresses.state_id')
                                        ->leftJoin('cities','cities.id','=','user_addresses.city_id')
                                        ->where('user_addresses.user_id',$user_id)
                                        ->select('user_addresses.*','countries.name as country_name','states.name as state_name','cities.name as city_name')
                                        ->get();
           return $this->sendResponse($addressData, 'Your Addresses list');
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
    /**
     * Edit Address api
     *
     * @return \Illuminate\Http\Response
     */
    
    public function editUserAddress(Request $request,$id=0)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $addressData  = UserAddress::where('user_addresses.user_id',$user_id)
                                        ->where('user_addresses.id',$id)
                                        ->select('user_addresses.*')
                                        ->first();
           return $this->sendResponse($addressData, 'Addresses Data');
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
     public function updateUserAddress(Request $request){
        $validator = Validator::make($request->all(), [
            'address_id' => 'required',
            'mobile' =>'required'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $data = UserAddress::find($request->address_id);
        if($request->default_address == 1){
             if(!empty($getAlreadyDefaultAddress)){
            $getAlreadyDefaultAddress = UserAddress::where('user_id',$request->user()->id)->where('default_address',1)->first();
            $getAlreadyDefaultAddress->default_address = 0;
            $getAlreadyDefaultAddress->save();
             }
        }
        $data->user_id = $request->user()->id;
        if(!empty($request->name)){
            $data->name = $request->name;
        }
        
         if(!empty($request->mobile)){
            $data->mobile = $request->mobile;
        }
        
         if(!empty($request->address_type)){
            $data->address_type = $request->address_type;
        }
        
         if(!empty($request->country_id)){
            $data->country_id = $request->country_id;
        }
        
        
          if(!empty($request->state_id)){
            $data->state_id = $request->state_id;
        }
        
        
          if(!empty($request->city_id)){
            $data->city_id = $request->city_id;
        }
        
        
          if(!empty($request->pin_code)){
            $data->pin_code = $request->pin_code;
        }
        
          if(!empty($request->address)){
            $data->address = $request->address;
        }
        
          if(!empty($request->locality)){
            $data->locality = $request->locality;
        }
        
          if(!empty($request->default_address)){
            $data->default_address = $request->default_address;
        }
        
        if($data->save()){
            return $this->sendResponse($data,'User Address Updated Successfully');
        }else{
            return $this->sendError('User not added');
        }
    }
    
    
     /**
     * Delete Address api
     *
     * @return \Illuminate\Http\Response
     */
    
    public function deleteUserAddress(Request $request,$id=0)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $userAddress = UserAddress::find($id);
           if(!empty($userAddress)){
               $userAddress->delete();
                return $this->sendResponse($userAddress, 'Address Deleted Succesfully');
           }else{
               return $this->sendError('Address Id Not Exist In Database');
           }
           
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
    public function addRatingReviewForProduct(Request $request){
        $validator = Validator::make($request->all(), [
            'review' => 'required',
            'rating' => 'required',
            'product_id' => 'required',
            'order_detail_id' =>'required'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $user_id = $request->user()->id;
        $input = $request->all();
        $data = new Review();
        $data->product_id = $input['product_id'];
        $data->product_color_id = $input['product_color_id'];
        $data->product_size_id = $input['product_size_id'];
        $data->user_id = $user_id;
        $data->rating = $input['rating'];
        $data->review = $input['review'];
        $data->save();
        if($data->save()){
            OrderDetail::where('id',$input['order_detail_id'])->update(array(
                         'is_rating_done'=>1,
            ));
            return $this->sendResponse($data, 'Your Product review added successfully');
        }else{
            return $this->sendError('Please Add Product First');
        }
    }
    
    
    public function getProductRatingReview(Request $request,$id = 0)
    {
       if($id){
           $productData  = Product::where('products.id',$id);
                                    
                                    
            if(isset($request->sort_by) && !empty($request->sort_by)){
                if($request->sort_by == 'higest'){
                    $productData =   $productData->with(['reviews' => function ($query) {
                            $query->orderBy('rating', 'desc'); // Sort the reviews by rating in descending order
                        }]);
                }else if($request->sort_by == 'lowest'){
                      $productData =   $productData->with(['reviews' => function ($query) {
                            $query->orderBy('rating', 'asc'); // Sort the reviews by rating in descending order
                        }]);
                }else if($request->sort_by == 'newest'){
                      $productData =   $productData->with(['reviews' => function ($query) {
                            $query->orderBy('id', 'desc'); // Sort the reviews by rating in descending order
                        }]);
                }
            }else{
                $productData =   $productData->with(['reviews' => function ($query) {
                    $query->orderBy('id', 'desc'); // Sort the reviews by rating in descending order
                }]);
            }
            
            $productData = $productData->select('products.id','products.name','products.average_rating','products.total_no_of_rating')->first();
                                  
           if($productData){
                    $productData->five_star_rating = Review::where('product_id',$productData->id)->where('rating',5)->count();
                    $productData->four_star_rating = Review::where('product_id',$productData->id)->where('rating',4)->count();
                    $productData->three_star_rating = Review::where('product_id',$productData->id)->where('rating',3)->count();
                    $productData->two_star_rating = Review::where('product_id',$productData->id)->where('rating',2)->count();
                    $productData->one_star_rating = Review::where('product_id',$productData->id)->where('rating',1)->count();
                    
                    $reviews = $productData->reviews;

                    // Extract color names from reviews and pass them in the review array
                    $reviewArray = [];
                    foreach ($reviews as $review) {
                        $getProCOlor = ProductColor::where('id',$review->product_color_id)->with('color')->first();
                        $getProSize = ProductSize::where('id',$review->product_size_id)->with('size')->first();
                      //  echo '<pre/>';print_r($getProCOlor->color);die;
                              if(!empty($getProCOlor)){
                            $review->product_color_name = $getProCOlor->color->name;
                             $review->product_color_code = $getProCOlor->color->code;
                              }else{
                                   $review->product_color_name = "";
                                  $review->product_color_code = "";
                              }
                             if(!empty($getProSize)){
                             $review->product_size_name = $getProSize->size->name;
                             }else{
                                 $review->product_size_name = "";
                             }
                    
                    }
                
                    // Now you have the product and its associated reviews with color names
                   // echo '<pre/>';print_r($reviewArray);die;
                  //  $productData->reviews = $reviewArray;
               
               return $this->sendResponse($productData, 'Your Product Rating Review list');
           }else{
               return $this->sendError('Product Not Exist In Database.Please add product first.');
           }
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
    public function getUserCartList(Request $request)
    {
      $user_id = $request->user()->id;;
               $cartData  = Cart::leftJoin('products','products.id','=','carts.product_id')
                                    ->leftJoin('product_sizes','product_sizes.id','=','carts.product_size_id')
                                    ->leftJoin('colors','colors.id','=','products.color_id')
                                    ->leftJoin('sizes','sizes.id','=','product_sizes.size_id')
                                    ->select('carts.*','products.name as product_name','products.front_image','product_sizes.size_id','colors.name as color_name','colors.code as color_code','sizes.name as size_name');
                                
                                     $cartData = $cartData->where('user_id',$user_id);
                                 
                                    
                                    
                                    $cartData=$cartData->get();
           if($cartData){
               return $this->sendResponse($cartData, 'Your Cart list');
           }else{
               return $this->sendError('Your Cart is Empty.');
           }
       
       
    }
    
    
    
    public function addProductToCart(Request $request){
         $validator = Validator::make($request->all(), [
            'product_size_id' => 'required',
            'product_id' => 'required',
            'quantity' =>'required'
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $user_id = $request->user()->id;;
        $input = $request->all();
        $checkAlready = Cart::where('product_id',$input['product_id'])->where('user_id',$user_id)->where('product_size_id',$input['product_size_id'])->first();
       
        if(empty($checkAlready)){
             $data = new Cart();
              $data->quantity = $input['quantity'];
        }else{
             $data = Cart::find($checkAlready->id);
             $data->quantity = $input['quantity'];
        }
       
        $data->product_id = $input['product_id'];
        $data->user_id = $user_id;
        $data->product_size_id = $input['product_size_id'];
        
        $data->amount = $input['amount'];
        $data->save();
        if($data->save()){
        
            return $this->sendResponse($data, 'Your Product added to cart successfully');
        }else{
            return $this->sendError('Please Add Product First');
        }
    }
    
     public function removeCartItem(Request $request,$id=0)
    {
       
           $userCartItem = Cart::find($id);
           if(!empty($userCartItem)){
               $userCartItem->delete();
                return $this->sendResponse($userCartItem, 'Cart Item Deleted Succesfully');
           }else{
               return $this->sendError('Id Not Exist In Database');
           }
           
       
    }
    
    
    public function getUserwishList(Request $request)
    {
            $user_id =$request->user()->id;
           $wishlistData  = Wishlist::leftJoin('products','products.id','=','wishlists.product_id')
                                            ->select('wishlists.*','products.name as product_name','products.front_image as front_image')
                                            ->where('user_id',$user_id)
                                            ->get();
       if($wishlistData){
            foreach($wishlistData as $productData){
         
              $sizeData = ProductSize::where('product_id',$productData->product_id)->orderBy('id','asc')->first();
              $productData->price = $sizeData->price;
              $productData->sell_price = $sizeData->sell_price;
          }
           return $this->sendResponse($wishlistData, 'Your Wish list');
       }else{
           return $this->sendError('Your Wishlist is Empty.');
       }
     
       
    }
    
    
    
  public function productQtyIncrease(Request $request)
{
    $validator = Validator::make($request->all(), [
        'cart_id' => 'required',
        'product_id' => 'required',
        'product_size_id' => 'required',
        'quantity' => 'required|integer|min:1', 
    ]);

    if ($validator->fails()) {
        return $this->sendError('Validation Error.', $validator->errors());
    }

    // Get the authenticated user
    $user = Auth::user();

    // Check if the user is authenticated
    if (!$user) {
        return response()->json(['error' => 'Unauthorized'], 401);
    }

    $input = $request->all();
    $cartItem = Cart::where('id', $input['cart_id'])
        ->where('user_id', $user->id)
        ->where('product_id', $input['product_id'])
        ->where('product_size_id', $input['product_size_id'])
        ->first();

    if (!$cartItem) {
        return $this->sendError('Cart item not found.');
    }

    // Increase quantity by 1 each time + button is clicked
    $cartItem->quantity += 1;
    
    // Update the amount based on the product_size_id
    $productSize = ProductSize::find($input['product_size_id']);
    $cartItem->amount = $productSize->price * $cartItem->quantity;

    $cartItem->save();

    return $this->sendResponse($cartItem, 'Product quantity increased successfully');
}




public function productQtyDecrease(Request $request)
{
    $validator = Validator::make($request->all(), [
        'cart_id' => 'required',
        'product_id' => 'required',
        'product_size_id' => 'required',
        'quantity' => 'required|integer|min:1',
    ]);

    if ($validator->fails()) {
        return $this->sendError('Validation Error.', $validator->errors());
    }

    // Get the authenticated user
    $user = Auth::user();

    // Check if the user is authenticated
    if (!$user) {
        return response()->json(['error' => 'Unauthorized'], 401);
    }

    $input = $request->all();

    // Find the cart item by cart_id, product_id, and product_size_id
    $cartItem = Cart::where('id', $input['cart_id'])
        ->where('user_id', $user->id)
        ->where('product_id', $input['product_id'])
        ->where('product_size_id', $input['product_size_id'])
        ->first();

    if (!$cartItem) {
        return $this->sendError('Cart item not found.');
    }

    // Decrease quantity by 1 each time the function is called
    $newQuantity = $cartItem->quantity - 1;

    // Ensure the new quantity is at least 1
    if ($newQuantity >= 1) {
        $cartItem->quantity = $newQuantity;
        // Update the amount based on the product_size_id
        $productSize = ProductSize::find($cartItem->product_size_id);
        $cartItem->amount = $productSize->price * $newQuantity; 
        $cartItem->save();

        return $this->sendResponse($cartItem, 'Product quantity decreased successfully');
    } else {
        return $this->sendError('Quantity must be at least 1.');
    }
}




    
    
    
    public function addProductToWishlist(Request $request){
         $validator = Validator::make($request->all(), [
            'product_id' => 'required',
        ]);
   
        if($validator->fails()){
            return $this->sendError('Validation Error.', $validator->errors());       
        }
        $user_id = $request->user()->id;
        $input = $request->all();
        $checkAlready = Wishlist::where('product_id',$input['product_id'])->where('user_id',$user_id)->first();
      
        if(!empty($checkAlready)){
            $checkAlready->delete();
            return $this->sendResponse($checkAlready, 'Your Product removed to wishlist successfully');
            
        }else{
            $data = new Wishlist();
            $data->product_id = $input['product_id'];
            $data->user_id = $user_id;
            $data->save();
            if($input['product_id']){
        
                return $this->sendResponse($data, 'Your Product added to wishlist successfully');
            }else{
                return $this->sendError('Please Add Product First');
            }
        }
        
        
        
    }
    
      public function removeWishlistItem(Request $request,$id=0)
    {
       
           $userWishlistItem = Wishlist::where('id',$id)->first();
           if(!empty($userWishlistItem)){
               $userWishlistItem->delete();
                return $this->sendResponse($userWishlistItem, 'Wishlist Item Deleted Succesfully');
           }else{
               return $this->sendError('Id Not Exist In Database');
           }
     
       
    }
    
    
    //  public function applyCouponCode(Request $request){
    //     $validator = Validator::make($request->all(), [
    //         'coupon_code' => 'required',
    //     ]);
   
    //     if($validator->fails()){
    //         return $this->sendError('Validation Error.', $validator->errors());       
    //     }
    //     $user_id = $request->user()->id;
    //     if($user_id){
    //         $checkCouponExist = Coupon::where('code',$request->coupon_code)->first();
    //         if(!empty($checkCouponExist)){
    //             if($checkCouponExist->is_active == 1){
    //                 $chkAlreadyUsedCoupon =Order::where('coupon_id',$checkCouponExist->id)->where('user_id',$user_id)->first();
    //                 if(empty($chkAlreadyUsedCoupon)){
    //                     $message = $checkCouponExist->percentage.'% Coupon Applied.';
    //                      return $this->sendResponse($checkCouponExist, $message);
    //                 }else{
    //                      return $this->sendError('Coupon Already Used.');   
    //                 }
                    
    //             }else{
    //                 return $this->sendError('Coupon Not Activated..please try with new coupon code.');
    //             }
                
    //         }else{
    //             return $this->sendError('Coupon Not Valid');
    //         }
    //     }else{
    //       return $this->sendError('User Not Exist In Database');
    //     }
    // }
    
    public function applyCouponCode(Request $request){
    $validator = Validator::make($request->all(), [
        'coupon_code' => 'required',
    ]);

    if($validator->fails()){
        return $this->sendError('Validation Error.', $validator->errors());       
    }

    $user_id = $request->user()->id;

    if($user_id){
        $checkCouponExist = Coupon::where('code', $request->coupon_code)->first();

        if(!empty($checkCouponExist)){
            if($checkCouponExist->is_active == 1){

                // Check if coupon has expired
                $currentDate = now();
                $endDate = \Carbon\Carbon::parse($checkCouponExist->end_date);

                if($endDate->isPast()){
                    return $this->sendError('Coupon has expired.');
                }

                $chkAlreadyUsedCoupon = Order::where('coupon_id', $checkCouponExist->id)
                    ->where('user_id', $user_id)
                    ->first();

                if(empty($chkAlreadyUsedCoupon)){
                    $message = $checkCouponExist->percentage.'% Coupon Applied.';
                    return $this->sendResponse($checkCouponExist, $message);
                }else{
                    return $this->sendError('Coupon Already Used.');   
                }
                
            }else{
                return $this->sendError('Coupon Not Activated..please try with a new coupon code.');
            }
            
        }else{
            return $this->sendError('Coupon Invalid');
        }
    }else{
        return $this->sendError('User Not Exist In Database');
    }
}

    
    // public function placeOrder(Request $request){
    //     $validator = Validator::make($request->all(), [
    //         'address_id' => 'required',
    //     ]);
   
    //     if($validator->fails()){
    //         return $this->sendError('Validation Error.', $validator->errors());       
    //     }
    //     $user_id = $request->user()->id;
    //     if($user_id){
    //         Cart::where('user_id',$user_id)->delete();
    //         $data = new Order();
    //         $data->user_id = $user_id;
    //         $data->mobile_number	 =$request->user()->phone_number;
    //         $data->order_number = mt_rand(1000000000, 9999999999);
    //         $data->address_id = $request->address_id;
    //         $data->coupon_id = $request->coupon_id;
    //         $data->note_box = $request->note;
    //         $data->order_status = "Pending";
            
    //         $data->payment_mode = $request->payment_mode;
    //         $data->order_amount = $request->order_amount;
    //         $data->discount_amount = $request->discount_amount;
    //         $data->order_amount_after_discount = $request->order_amount_after_discount;
    //         $data->save();
                
    //         if(!empty($request->items)){
    //             foreach($request->items as $itemData){
    //                  $detail = new OrderDetail();
    //                 $detail->order_id = $data->id;
    //                 $detail->user_id = $user_id;
    //                 $detail->product_id = $itemData['product_id'];
                    
    //                 $detail->product_size_id = $itemData['product_size_id'];
    //                 $detail->pro_actual_price = $itemData['pro_actual_price'];
    //                 $detail->total_price = $itemData['total_price'];
    //                 $detail->quantity = $itemData['quantity'];
    //                 $detail->save();
    //             }
    //         }    
    //         // $this->sendNotification();
    //         // $noti = new Notification();
    //         // $noti->user_id = $user_id;
    //         // $noti->notification = "Your Order has been placed successfully";
    //         // $noti->save();
            
        


    //         return $this->sendResponse($data, 'Order Placed successfully');
    //     }else{
    //       return $this->sendError('User Not Exist In Database');
    //     }
    // }
    
public function placeOrder(Request $request){
    $validator = Validator::make($request->all(), [
        'address_id' => 'required',
    ]);

    if($validator->fails()){
        return $this->sendError('Validation Error.', $validator->errors());       
    }

    $user_id = $request->user()->id;

    if($user_id){
        // Fetch cart data, replace this line accordingly
        $cart = Cart::where('user_id', $user_id)->get();

        Cart::where('user_id', $user_id)->delete();

        $data = new Order();
        $data->user_id = $user_id;
        $data->mobile_number = $request->user()->phone_number;
        $data->order_number = mt_rand(1000000000, 9999999999);
        $data->address_id = $request->address_id;
        $data->coupon_id = $request->coupon_id;
        $data->note_box = $request->note;
        $data->shipping_amount = $request->shipping_amount;
        $data->order_status = "Pending";
        $data->payment_mode = $request->payment_mode;
        $data->order_amount = $request->order_amount;
        $data->discount_amount = $request->discount_amount;
        $data->order_amount_after_discount = $request->order_amount_after_discount;
        $data->save();

        if (!empty($cart)) {
            foreach ($cart as $itemData) {
                $detail = new OrderDetail();
                $detail->order_id = $data->id;
                $detail->user_id = $user_id;
                $detail->product_id = $itemData->product_id;
                $detail->product_size_id = $itemData->product_size_id;
                $detail->pro_actual_price = $itemData->pro_actual_price;
                $detail->total_price = $itemData->amount;
                $detail->quantity = $itemData->quantity;
                $detail->save();
            }
        }    

        // Additional logic like sending notifications can be added here

        return $this->sendResponse($data, 'Order Placed successfully');
    } else {
        return $this->sendError('User Not Exist In Database');
    }
}

    
    public function getAllOrders(Request $request)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $orderData  = OrderDetail::where('order_details.user_id',$user_id)
                                    ->leftJoin('products','products.id','=','order_details.product_id')
                                    ->leftJoin('product_sizes','product_sizes.id','=','order_details.product_size_id')
                                    ->leftJoin('colors','colors.id','=','products.color_id')
                                    ->leftJoin('sizes','sizes.id','=','product_sizes.size_id')
                                    ->select('order_details.*','products.name as product_name','products.front_image','products.color_id','product_sizes.size_id','colors.name as color_name','colors.code as color_code','sizes.name as size_name')
                                    ->get();
           return $this->sendResponse($orderData, 'Your Order list');
       }else{
           return $this->sendError('User Not Exist In Database');
       }
    }
    
    public function getOrderDetail(Request $request,$id = 0){
        $user_id = $request->user()->id;
       if($user_id){
           $orderData  = OrderDetail::where('order_details.id',$id)
                                        ->leftJoin('products','products.id','=','order_details.product_id')
                                        ->leftJoin('product_sizes','product_sizes.id','=','order_details.product_size_id')
                                        ->leftJoin('colors','colors.id','=','products.color_id')
                                        ->leftJoin('sizes','sizes.id','=','product_sizes.size_id')
                                        ->select('order_details.*','products.name as product_name','products.front_image','products.color_id','product_sizes.size_id','colors.name as color_name','colors.code as color_code','sizes.name as size_name')
                                        ->first();
            $getOrderData = Order::where('id',$orderData->order_id)->first();
            $addressData  = UserAddress::leftJoin('countries','countries.id','=','user_addresses.country_id')
                                        ->leftJoin('states','states.id','=','user_addresses.state_id')
                                        ->leftJoin('cities','cities.id','=','user_addresses.city_id')
                                        ->where('user_addresses.id',$getOrderData->address_id)
                                        ->select('user_addresses.*','countries.name as country_name','states.name as state_name','cities.name as city_name')
                                        ->first();                            
           
            $orderInformation = [
                'orderData' => $orderData,
                'address' => $addressData,
            ];
           return $this->sendResponse($orderInformation, 'Your Order Detail');
       }else{
           return $this->sendError('User Not Exist In Database');
       }
    }
    
    
      public function userNotificationsList(Request $request)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $notificationData  = Notification::where('user_id',$user_id)->select('notifications.*')->get();
           if($notificationData){
               
               return $this->sendResponse($notificationData, 'Your Notifications list');
           }else{
               return $this->sendError('Notifications Not Exist In Database');
           }
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    public function deleteAllNotification(Request $request)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $notificationData  = Notification::where('user_id',$user_id)->delete();
           
               return $this->sendError('Notifications Deleted Successfully');
           
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
     public function readNotification(Request $request,$id)
    {
       $user_id = $request->user()->id;
       if($user_id){
           $notificationData  = Notification::where('user_id',$user_id)->where('id',$id)->select('notifications.*')->first();
           if($notificationData){
               $notificationData->is_read = 1;
               $notificationData->save();
               return $this->sendResponse($notificationData, 'Notification read successfully');
           }else{
               return $this->sendError('Notifications Not Exist In Database');
           }
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
    
    public function saveReelData(Request $request){
        $user_id = $request->user()->id;
        $data = new Reel();
        $data->user_id = $user_id;
        $data->product_id = $request->product_id;
        $image = $request->file('cover_photo');
        if(isset($image) && !empty($image)){
            $imageName = time().'.'.$image->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/reels');
            $image->move($destinationPath, $imageName);
            $imagePath = 'public/uploads/reels/'.$imageName;
            $data->cover_photo=$imagePath;
        }
        
        $reel = $request->file('reel');
        if(isset($reel) && !empty($reel)){
            $reelImageName = time().'.'.$reel->getClientOriginalExtension();
            $destinationPath = public_path('/uploads/reels');
            $reel->move($destinationPath, $reelImageName);
            $imagePath = 'public/uploads/reels/'.$reelImageName;
            $data->reel=$imagePath;
        }
        if($data->save()){
            return $this->sendResponse($data,'Your Reel Data successfully');
        }else{
            return $this->sendError('User not added');
        }
    }
    
    
    public function getUserReelData(Request $request)
    {
       
           $reelData  = Reel::where('is_approved',1)->select('reels.*')->get();
           if($reelData){
               
               return $this->sendResponse($reelData, 'Your Reels Data list');
           }else{
               return $this->sendError('Reels Not Exist In Database');
           }
       
       
    }
}