<?php

namespace App\Http\Controllers;
use App\Http\Controllers\Traits\CommonFunctionsTrait;
use Illuminate\Http\Request;
use Auth;
use App\Models\User;
use Session;
use Illuminate\Support\Facades\Validator;
use Hash;
use DB;
use App\Models\Category;
use App\Models\Subcategory;
use App\Models\Product;
use App\Models\Cart;
use App\Models\CartDetail;
use App\Models\Color;
use App\Models\Size;
use App\Models\Review;
use App\Models\UserAddress;
use App\Models\OrderDetail;
use App\Models\Order;
use App\Models\ProductOptionImage;
use App\Models\Coupon;
use App\Models\Wishlist;
use App\Models\SubscriptionType;
use App\Models\ProductSize;
use Ixudra\Curl\Facades\Curl;

use Carbon\Carbon; 
use Mail;
use Illuminate\Support\Str;
use App\Mail\UserResetPassword;
use App\Mail\UserRegisterSuccessfully;
use App\Mail\AdminUserRegisterSuccessfully;
use Illuminate\Support\Arr;
use Illuminate\Support\Facades\Log;


class CartController extends Controller
{
    use CommonFunctionsTrait;
   // add to cart and save details to database

      public function addToCart(Request $request) {
      $productData =    Product::where('id',$request->product_id)->first();
             $validator = Validator::make($request->all(), [
                'product_id' => 'required',
                'size' => 'required',
            ],[
                'product_id.required' => 'Please select product',
                'size.required' => 'Please select size',
    
    
            ]);
        if ($validator->passes()) {
            try {
          
              $quantity = $request->quantity;
                $product = Product::findOrFail($request->product_id);
                $chkStock = ProductSize::where('id',$request->size)->first();
                if($chkStock->stock > 0) {
                      if (Auth::check()) {
                            $cartIdentifier = null;
                            $userId = Auth::user()->id;
                        } else {
                            $cartIdentifier = $request->cookie('cart_identifier');
                            if (!$cartIdentifier) {
                                $cartIdentifier = Str::uuid()->toString();
                            }
                            $userId = null;
                        }
                        
                      $cart_detail = Cart::where('user_id',$userId)
                                          ->where('random_id',$cartIdentifier)
                                          ->where('product_id',$product->id)
                                          ->where('product_size_id',$request->size)
                                          ->first();
                            if(!empty($cart_detail)) {
                                $cart_detail->quantity =  $cart_detail->quantity + $quantity;
                                 $cart_detail->save();
                                 
                                
                            } else {
                                $data = new Cart();
                                $data->user_id = $userId;
                                $data->random_id = $cartIdentifier;
                                $data->product_id = $product->id;
                                $data->quantity = $request->quantity;
                                if(!empty($request->size)){
                                      $data->product_size_id = $request->size;
                                }
                                if(!empty($request->color)){
                                      $data->product_color_id = $request->color;
                                }
                                
                                $data->save();
                                
                            }
                            
                            
                            if (!$userId) {
                                $cookie = cookie('cart_identifier', $cartIdentifier, 1440);
                                return response()->json(['success'=>1,'message' => 'Item added to cart successfully'])->cookie($cookie);
                            } else {
                                return response()->json(['success'=>1,'message' => 'Item added to cart successfully']);
                            }
                     } else {
                    return response()->json([
                        'success' => false,
                        'code' => 401,
                        'errors' => 'Out of Stock',
                    ]);
                }
          
              
            } catch(\Exception $ex) {
                return response()->json([
                    'success' => false,
                    'code' => 402,
                    'errors' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }
    




 public function cancelOrder(Request $request) {
        
       $productData =    Product::where('id',$request->product_id)->first();
             $validator = Validator::make($request->all(), [
                'order_id' => 'required',
            ],[
                'order_id.required' => 'Please select product',
            ]);
         
     
         
       
        if ($validator->passes()) {
            try {
          
                $order = Order::find($request->order_id);
                //echo '<pre/>';print_r($order);die;
                $this->cancelAfterShipLabel($order);
                if($chkStock->stock > 0) {
                      return response()->json(['success'=>1,'message' => 'Item added to cart successfully']);
                     } 
          
              
            } catch(\Exception $ex) {
                return response()->json([
                    'success' => false,
                    'code' => 402,
                    'errors' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }

    // cart details 

// public function cartDetails(Request $request)  {
       
//         try {

//               $cartItems = [];

//                 // Check if the user is logged in
//                 if (Auth::check()) {
//                     // If the user is logged in, fetch the cart items associated with their user ID
//                     $cartItems = Cart::with('product')
//                         ->where('user_id', Auth::id())
//                         ->get();
//                 } else {
//                     // If the user is not logged in, fetch the cart items associated with the cart identifier cookie
//                     $cartIdentifier = $request->cookie('cart_identifier');
//                     if ($cartIdentifier) {
//                         $cartItems = Cart::with('product')
//                             ->where('random_id', $cartIdentifier)
//                             ->get();
//                     }
//                 }
            
//                 return view('front.cart-details',compact('cartItems'));
            
                  
                   
               
//         } catch(\Exception $ex) {
//             dd($ex->getMessage());
//         }
//     }
    
    
    public function cartDetails(Request $request) {
    try {
        $cartItems = [];

        if (Auth::check()) {
            $cartItems = Cart::with('product')
                ->where('user_id', Auth::id())
                ->get();
        } else {
            $cartIdentifier = $request->cookie('cart_identifier');
            if ($cartIdentifier) {
                $cartItems = Cart::with('product')
                    ->where('random_id', $cartIdentifier)
                    ->get();
            }
        }

        return view('front.cart-details', compact('cartItems'));

    } catch (\Exception $ex) {
        dd($ex->getMessage());
    }
}



    
    
    public function getSizePrice(Request $request)
    {
        $sizeId = $request->size_id;
        $sizeData = ProductSize::where('id',$sizeId)->first();
        return view('front.price-details',compact('sizeData'));   
    }

    
    




//  public function increaseCartItemQuantity(Request $request, $cart_id) {
//     $cart_detail = Cart::find($cart_id);
    
//     if (!$cart_detail) {
//         return redirect()->route('cartDetails')->with('error', 'Cart Item not found');
//     }

//     $cart_detail->update([
//         'quantity' => $cart_detail->quantity + 1,
//     ]);

//     return redirect()->route('cartDetails')->with('success', 'Cart Updated');
// }

// public function decreaseCartItemQuantity(Request $request, $cart_id) {
//     $cart_detail = Cart::find($cart_id);

//     if (!$cart_detail) {
//         return redirect()->route('cartDetails')->with('error', 'Cart Item not found');
//     }

//     if ($cart_detail->quantity > 1) {
//         $cart_detail->update([
//             'quantity' => $cart_detail->quantity - 1,
//         ]);
//     } else {
//         $cart_detail->delete();
//     }

//     return redirect()->route('cartDetails')->with('success', 'Cart Updated');
// }


public function increaseCartItemQuantity(Request $request, $cart_id) {
    $cart_detail = Cart::find($cart_id);
    
    if (!$cart_detail) {
        return response()->json(['success' => false, 'error' => 'Cart Item not found']);
    }

    $cart_detail->update([
        'quantity' => $cart_detail->quantity + 1,
    ]);

    return response()->json(['success' => true, 'quantity' => $cart_detail->quantity]);
}

public function decreaseCartItemQuantity(Request $request, $cart_id) {
    $cart_detail = Cart::find($cart_id);

    if (!$cart_detail) {
        return response()->json(['success' => false, 'error' => 'Cart Item not found']);
    }

    if ($cart_detail->quantity > 1) {
        $cart_detail->update([
            'quantity' => $cart_detail->quantity - 1,
        ]);
    } else {
        $cart_detail->delete();
    }

    return response()->json(['success' => true, 'quantity' => $cart_detail->quantity]);
}



 public function removeFromCart(Request $request , $cart_id)
    {
        try {
            

                Cart::where('id',$cart_id)->delete();
               
             
            return response()->json([
                'success' => true,
                'message' =>"Item deleted from cart"
            ]);
        } catch(\Exception $ex) {
            return response()->json([
                'success' => false,
                'code' => 400,
                'errors' => $ex->getMessage() .'-'.$ex->getLine(),
            ]);
        }
    }
// apply coupon code 

//  public function applyCoupon(Request $request)
//     {
//         $validator = Validator::make($request->all(), [
//             'coupon_code' => 'required',
//         ],[
//                  'coupon_code.required' => 'Enter coupon code.',
//         ]);
//         if ($validator->passes()) {
//             try {
//                 $customer = Auth::user();
//                 $validityDate = date('Y-m-d');
//                 $coupon = Coupon::where('code',$request->coupon_code)
//                             ->whereDate('end_date','>=',$validityDate)
//                             ->where('is_active',1)
//                             ->first();
//                             // dd($request->coupon_code);
                           
//                 if($coupon) {
//                      $checkAlreadyUse = Order::where('user_id',$customer->id)->where('coupon_id',$coupon->id)->first();
//                      $totalUsed = Order::where('coupon_id',$coupon->id)->count();
                     
//                      if($totalUsed < $coupon->coupon_applied){
                         
//                           if(empty($checkAlreadyUse)){
//                                 $coupon_discount = ($request->total * $coupon->percentage)/100; 
//                                 return response()->json([
//                                     'success' => true,
//                                     'message' => 'Coupon Applied',
//                                     'coupon_discount' => $coupon_discount,
//                                     'coupon_id' => $coupon->id
//                                 ]);
                           
//                         } else{
//                             return response()->json([
//                                         'success' => false,
//                                         'code' => 301,
//                                         'message' => 'You have already used this coupon.',
//                                     ]);
//                           } 
//                      }else{
//                          return response()->json([
//                                 'success' => false,
//                                 'code' => 422,
//                                 'message' => 'Max Used Reach',
//                                 'errors' => [
//                                     'coupon_code' => [
//                                         'Max Used Reach',
//                                     ],
//                                 ],
//                             ]);   
//                      }
                  
                     
//             } else {
//                         return response()->json([
//                                 'success' => false,
//                                 'code' => 422,
//                                 'message' => 'Invalid Coupon',
//                                 'errors' => [
//                                     'coupon_code' => [
//                                         'Invalid Coupon',
//                                     ],
//                                 ],
//                             ]);
//                         }
//             } catch(\Exception $ex) {
//                 return response()->json([
//                     'success' => false,
//                     'code' => 400,
//                     'errors' => $ex->getMessage() .'-'.$ex->getLine(),
//                 ]);
//             }
//         } else {
//             return response()->json([
//                 'success' => false,
//                 'code' => 422,
//                 'errors' => $validator->errors(),
//             ]);
//         }
//     }


public function applyCoupon(Request $request)
{
    $validator = Validator::make($request->all(), [
        'coupon_code' => 'required',
    ], [
        'coupon_code.required' => 'Enter coupon code.',
    ]);

    if ($validator->passes()) {
        try {
            $customer = Auth::user();
            
            $validityDate = date('Y-m-d');
            
            $coupon = Coupon::where('code', $request->coupon_code)
                ->whereDate('end_date', '>=', $validityDate)
                ->where('is_active', 1)
                ->first();
// dd($coupon);
            if ($coupon) {
                $checkAlreadyUse = Order::where('user_id', $customer->id)
                    ->where('coupon_id', $coupon->id)
                    ->first();
                if ($coupon->remaining_uses > 0) {
                    if (empty($checkAlreadyUse)) {
                        $coupon_discount = ($request->total * $coupon->percentage) / 100;
                        $coupon->decrement('remaining_uses');
                         Log::info('Remaining Uses After Decrement: ' . $coupon->remaining_uses);

                        return response()->json([
                            'success' => true,
                            'message' => 'Coupon Applied',
                            'coupon_discount' => $coupon_discount,
                            'coupon_id' => $coupon->id,
                        ]);
                    } else {
                        return response()->json([
                            'success' => false,
                            'code' => 301,
                            'message' => 'You have already used this coupon.',
                        ]);
                    }
                } else {
                    return response()->json([
                        'success' => false,
                        'code' => 422,
                        'message' => 'Max Used Reach',
                        'errors' => [
                            'coupon_code' => [
                                'Max Used Reach',
                            ],
                        ],
                    ]);
                }
            } else {
                return response()->json([
                    'success' => false,
                    'code' => 422,
                    'message' => 'Invalid Coupon',
                    'errors' => [
                        'coupon_code' => [
                            'Invalid Coupon',
                        ],
                    ],
                ]);
            }
        } catch (\Exception $ex) {
            return response()->json([
                'success' => false,
                'code' => 400,
                'errors' => $ex->getMessage() . '-' . $ex->getLine(),
            ]);
        }
    } else {
        return response()->json([
            'success' => false,
            'code' => 422,
            'errors' => $validator->errors(),
        ]);
    }
}



// update/delete wishlist data 
     public function updateWishlist(Request $request, $id)
    {
        try {
            $customer = Auth::user();
            //echo Auth::user()->id;die;
            $product = Product::findOrFail($id);
            $wishlist = Wishlist::where('user_id',$customer->id)->where('product_id',$product->id)->first();
            // dd(  $wishlist);
            $code = 200;
            if($wishlist) {
                $wishlist->delete();
                $code = 201;
            } else {
                $data = new Wishlist();
                $data->user_id = $customer->id;
                $data->product_id = $product->id;
                $data->save();
                
            }
            return response()->json([
                'success' => true,
                'code' => $code,
            ]);
        } catch(\Exception $ex) {
            return response()->json([
                'success' => false,
                'code' => 400,
                'message' => 'Please log in first',
                'error' => $ex->getMessage() .'-'.$ex->getLine(),
            ]);
        }
    }

// submit order reviews 
       public function submitProductReview(Request $request,$product_id)
    {
        $validator = Validator::make($request->all(), [
            'rating' => 'required|gt:0',
            'review' => 'required',
        ],[
            'name.required' => 'Enter your name',
            'email.required' => 'Enter your email',
            'review_title.required' => 'Sum up your review in one line',
            'rating.required' => 'Select your rating',
            'rating.gt' => 'Minimum 1 star to be selected',
            'review.required' => 'Write your review.',
        ]);
        if ($validator->passes()) {
            try {
                $customer = Auth::user();
                if($customer){
                    $data = new Review();
                    $data->product_id = $request->product_id;
                    $data->rating = $request->rating;
                    $data->review  = $request->review;
                    $data->user_id  = Auth::user()->id;
                    $data->save();
                  
          
               
                return response()->json([
                    'success' => true,
                    'message' => "Review Added"
                ]);
                }else{
                     return response()->json([
                    'success' => false,
                    'code' => 401,
                    'errors' => 'Please log in first to write a review',
                ]);
                }
               
            } catch(\Exception $ex) {
                return response()->json([
                    'success' => false,
                    'code' => 400,
                    'errors' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            return response()->json([
                'success' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }

// order checkout page 
public function checkout(Request $request)  {
       
        try {
            if(Auth::user()) {

                $cartItems = Cart::with('product')
                        ->where('user_id', Auth::id())
                        ->get();
                                
                    $customer = Auth::user();
                    $customer_addresses = UserAddress::latest()->where('user_id',$customer->id)->get();
                    return view('front.checkout',compact('cartItems','customer_addresses'));
                } else {
                    return redirect(url('/'));
                }
             
        } catch(\Exception $ex) {
            dd($ex->getMessage());
        }
    }


// submit order details 
    public function submitOrder(Request $request)
    {
        
                
                // 
                $apiKey = '099eb0cd-02cf-4e2a-8aca-3e6c6aff0399';
         $url = 'https://api-preprod.phonepe.com/apis/pg-sandbox/pg/v1/pay';

$data = [
    'merchantId' => 'PGTESTPAYUAT',
    'merchantTransactionId' => 'MT7850590068188104',
    'merchantUserId' => '671cd037911c3',
    'amount' => 1000,
    'redirectUrl' => 'https://shephaidawakhana.deuharmony.in/phonepe-response',
    'redirectMode' => 'POST',
    'callbackUrl' => 'https://shephaidawakhana.deuharmony.in/phonepe-response',
    'paymentInstrument' => [
        'type' => 'PAY_PAGE',
    ],
];

// Your salt key and index
$saltKey = $apiKey; // Replace with your actual salt key
$saltIndex = 1; // Replace with your actual salt index

// Convert data to JSON and Base64 encode it
$payload = base64_encode(json_encode($data));

// Create the string for hashing
$stringToHash = $payload . "/pg/v1/pay" . $saltKey;

// Generate SHA256 hash
$hash = hash('sha256', $stringToHash);

// Combine hash and salt index
$finalSignature = $hash . '###' . $saltIndex;

// Set up cURL
$ch = curl_init($url);

curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Accept: application/json',
    'Content-Type: application/json',
    'x-api-key: ' . $apiKey,
    'Signature: ' . $finalSignature,
]);

curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));

$response = curl_exec($ch);

if (curl_errno($ch)) {
    echo 'Error:' . curl_error($ch);
} else {
    echo $response;
}

curl_close($ch);
        
                
                
            
         
  
    }

  
               
 public function response2(Request $request){
     if($request->code == 'PAYMENT_SUCCESS'){
         $transactionId = $request->transactionId;
        $merchantId=$request->merchantId;
       $providerReferenceId=$request->providerReferenceId;
       $merchantOrderId=$request->merchantOrderId;
       $checksum=$request->checksum;
       $status=$request->code;
       
       //Transaction completed, You can add transaction details into database
 
 
       $data = [
    'providerReferenceId' => $providerReferenceId,
    'checksum' => $checksum,
    
];
if($merchantOrderId !=''){
     $data['merchantOrderId']=$merchantOrderId;
 }
 
Payment::where('transaction_id', $transactionId)->update($data); 
         
       return view('confirm_payment',compact('providerReferenceId', 'transactionId'));
 
    }else{
 
        //HANDLE YOUR ERROR MESSAGE HERE
        dd('ERROR : ' .$request->code. ', Please Try Again Later.');
    }
     
 }

  // thankyou after order placed
//     public function ThankYou(){
//   try {
           
//             $customer = Auth::user();
           
//             $orders = Order::where('user_id',$customer->id)->latest()->first();
//             $Address = UserAddress::where('id',$orders->address_id)->first();
//             return view('front.thank-you');
//         } catch(\Exception $ex) {
//             dd($ex->getMessage());
//         }
//     }

 public function ThankYou(){
    try {
        $customer = Auth::user();
        $orders = Order::where('user_id', $customer->id)->latest()->first();
        $Address = UserAddress::where('id', $orders->address_id)->first();
        return view('front.thank-you', ['order' => $orders]);
    } catch (\Exception $ex) {
        dd($ex->getMessage());
    }
}


       private function encryptPaymentData($plainText,$key)
{
   $key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$serializedData = serialize($plainText);
	$openMode = openssl_encrypt($plainText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	$encryptedText = bin2hex($openMode);
	return $encryptedText;
}


public function decrypt($encryptedText,$key)
{
	$key = $this->hextobin(md5($key));
	$initVector = pack("C*", 0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f);
	$encryptedText = $this->hextobin($encryptedText);
	$decryptedText = openssl_decrypt($encryptedText, 'AES-128-CBC', $key, OPENSSL_RAW_DATA, $initVector);
	return $decryptedText;
}

public function hextobin($hexString) 
 { 
	$length = strlen($hexString); 
	$binString="";   
	$count=0; 
	while($count<$length) 
	{       
	    $subString =substr($hexString,$count,2);           
	    $packedString = pack("H*",$subString); 
	    if ($count==0)
	    {
			$binString=$packedString;
	    } 
	    
	    else 
	    {
			$binString.=$packedString;
	    } 
	    
	    $count+=2; 
	} 
        return $binString; 
  } 
  
    public function paymentSuccess(Request $request)
    {
         error_reporting(0);

        $workingKey = 'D580001EC4A0B9DAE401DF36128F705B'; // Working Key should be provided here.
        $encResponse = $request->input("encResp");
        $rcvdString = $this->decrypt($encResponse, $workingKey);
        $order_status = "";
        $decryptValues = explode('&', $rcvdString);
        $dataSize = sizeof($decryptValues);
        $output = "<center>";

        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            if ($i == 3) $order_status = $information[1];
        }

        if ($order_status === "Success") {
            $output .= "<br>Thank you for shopping with us. Your credit card has been charged and your transaction is successful. We will be shipping your order to you soon.";
        } else if ($order_status === "Aborted") {
            $output .= "<br>Thank you for shopping with us. We will keep you posted regarding the status of your order through e-mail";
        } else if ($order_status === "Failure") {
            $output .= "<br>Thank you for shopping with us. However, the transaction has been declined.";
        } else {
            $output .= "<br>Security Error. Illegal access detected";
        }

        $output .= "<br><br>";

        $output .= "<table cellspacing=4 cellpadding=4>";
        for ($i = 0; $i < $dataSize; $i++) {
            $information = explode('=', $decryptValues[$i]);
            $output .= '<tr><td>' . $information[0] . '</td><td>' . $information[1] . '</td></tr>';
        }
        $output .= "</table><br>";
        $output .= "</center>";

        return view('payment.response', ['output' => $output]);
    }

    public function paymentFailure(Request $request)
    {
        // Handle payment failure in the test environment
    }
    


}