<?php

namespace App\Http\Controllers;

use \App\Models\User;
use \App\Models\Package;
use \App\Models\HelpTicket;
use Illuminate\Http\Request;


use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportUser;
use App\Exports\ExportUser;
use Auth;
class CompanyController extends Controller
{
    /**
     * Company Login View page
     */
    public function companyLogin(){    
        return view('company.login');
    }
    
    
     /**
     * Company Login Submit
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function companyLoginSubmit(Request $request)
    {   
       // echo 23;die;
        $input = $request->all();
     
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);
     
        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password'],'status'=>1,'type'=>config('global.LEARNING_PARTNER'))))
        {
            if (auth()->user()->type == 2) {
                return redirect()->route('partner.home');
            }else{
                return redirect()->route('login')
                ->with('error','Email-Address And Password Are Wrong.');
            }
        }else{
            return redirect()->route('login')
                ->with('error','Email-Address And Password Are Wrong.');
        }
          
    }
    
    
       public function addQuery(){
        $pageName = 'Query';
        $method = 'Add New';
      
       
           
        $result=HelpTicket::orderBy('id','desc')->get();
        $total=0;
        
        $page=0;
        return view('company.add_query',compact('pageName','method','result','total','page'));
    }
    
    public function SavePartnerQuery(Request $request){
        $data = new HelpTicket;
        $data->message = $request->message;
        $data->user_id = Auth::user()->id;
        $data->status = 'in_process';
      
        if($data->save()){
           
            return redirect()->route('partner.home')->with('success','Your Query Is Submitted Successfully');
        } else {
            return redirect()->back()->with('failed','New Vendor Created Faild. Please try again letter');
        }
    }
}
