<?php

namespace App\Http\Controllers;

use App\Models\Faq;
use Illuminate\Http\Request;
use DB;
class FaqController extends Controller
{
    
    /**
    * Show the form for creating a new Call center.
    *
    * @return \Illuminate\Http\Response
    */
    public function addFaq()
    {
        $data = Faq::latest()->get();
        return view('admin.faq.add',compact('data'));
    }
    
    /**
     * Store a newly created Call center in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function saveFaq(Request $request)
    {

       $request->validate([
            'question' => 'required',
            'answer' => 'required',
        ],[
            'question.required' => 'Please Enter Question',
            'answer.required' => 'Please Enter Answer',
            
        ]);
             DB::beginTransaction();
            try {
                $data = New Faq();
                $data->question = $request->question;
                $data->answer = $request->answer;
               if( $data->save()){
                    DB::commit();
                  // echo '<pre/>';print_r($data);die;
                          
                    return redirect()->route('faq.add')->with('success','Faq Data Added Successfully');
               }              
            } catch(\Exception $ex) {
                  DB::rollback();
                 return redirect()->back()->with('error',$ex->getMessage() .'-'.$ex->getLine());
            }
        
    }
    
      public function listFaq()
    {
        $data = Faq::latest()->get();
        return view('company.faq.list',compact('data'));
    }
}
