<?php
  
namespace App\Http\Controllers;
 
use Illuminate\Http\Request;
use \App\Models\User;
use \App\Models\Product;
use \App\Models\Booking;
use \App\Models\Order;
use App\Models\OrderDetail;
use Carbon\Carbon;
use DB;
use Auth;
use Illuminate\Support\Str;
use Mail;
use App\Mail\UserResetPassword;
  use Hash;
class HomeController extends Controller
{
    // /**
    //  * Create a new controller instance.
    //  *
    //  * @return void
    //  */
    // public function __construct()
    // {
    //     $this->middleware('auth');
    // }
  
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    } 
  
    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
     
     
    
     
    public function adminHome()
    {
        $currentYear = date('Y');
          $result = User::where('type', 0)->limit(10)->latest()->get();
        $orders = Order::leftJoin('users','users.id','=','orders.user_id')->select('orders.*','users.name as user_name')->limit(10)->latest()->get();
        
        $totalProduct = Product::count();
        $totalOrders = Order::count();
        $totalUsers = User::where('type',0)->count();
        $totalIncome = Order::sum('order_amount_after_discount');
      
   
            $ordersCountByMonth = Order::select(
            DB::raw('MONTH(created_at) as month'),
            DB::raw('COUNT(*) as total_orders'),
            DB::raw('SUM(order_amount_after_discount) as total_sales')
        )
        ->whereYear('created_at', $currentYear)
        ->where('order_status', '!=', 'Cancelled')
        ->groupBy('month')
        ->get();


        return view('admin.adminHome',compact('orders','totalProduct','totalOrders','totalUsers','totalIncome','result','ordersCountByMonth'));
    }
    
  
  public function registrationForm(){
       
        return view('front.register');
    }

 // register user 
        public function register(Request $request)
    {
       
        $validator = Validator::make($request->all(), [
            'name' => 'required',
            'email' => 'required|email|unique:users',
             'mobile' => 'required|unique:users',
            'password' => 'min:6|required', 
        ],[
            'name.required' => 'Enter your name.',
             'email.required' => 'Enter your email.',
              'mobile.required' => 'Enter your phone number.',
               'password.required' => 'Enter  password.',

        ]);
        if ($validator->passes()) {
            DB::beginTransaction();
            try {
                $user = User::create([
                    'name' => $request->name,
                    'email' => $request->email, 
                 'mobile' => $request->mobile, 
                  'country_code' => $request->country_code,                  
                    'userType' => 'user',
                     'birth_date' => $request->birth_date,
                    'password' => Hash::make($request->password)
                ]);
              
              Auth::login($user);
              
              
                DB::commit();
                return response()->json([
                    'status' => true,
                    'code' => 200,
                    'useremail' =>$user->email,
                ]);
            } catch(\Exception $ex) {
                DB::rollback();
                return response()->json([
                    'status' => false,
                    'code' => 400,
                    'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }


 public function loginForm(){
       
        return view('front.login');
    }

  public function login(Request $request)
    {
        //dd($request->all());
        $validator = Validator::make($request->all(), [
            'email' => 'required|email',
            'password' => 'required|min:6',
        ]);
        if ($validator->passes()) {
            DB::beginTransaction();
            try {
                $credentials = [
                    'email' => $request->email,
                    'password' => $request->password,
                    'userType' => 'user',
                ];
                if (Auth::attempt($credentials)) {
                    $user = Auth::user();
                    if($user->is_active == 1){

                    return response()->json([
                        'status' => true,
                    ]);
                        
                    }else{

                         return response()->json([

                        'status' => false,
                        'code' => 302,
                        'errors' => [
                            'email' => [
                                'Oops! looks like your email is deactivated,please contact customer support.'
                            ]
                        ]
                    ]);

                    }
                    
                } else {
                    DB::rollback();
                    return response()->json([
                        'status' => false,
                        'code' => 422,
                        'errors' => [
                            'email' => [
                                'Invalid Credential'
                            ]
                        ]
                    ]);
                }
            } catch(\Exception $ex) {
                DB::rollback();
                return response()->json([
                    'status' => false,
                    'code' => 400,
                    'msgText' => $ex->getMessage() .'-'.$ex->getLine(),
                ]);
            }
        } else {
            DB::rollback();
            return response()->json([
                'status' => false,
                'code' => 422,
                'errors' => $validator->errors(),
            ]);
        }
    }
    
    
     public function UserResetPasswordForm( ) {

    return view('front.reset_password');
            }

 public function SendUserResetPasswordLink(Request $request ) {
    $request->validate([
            'email' => 'required',
        ]);

    $user = DB::table('users')->where('email', '=', $request->email)->where('type',0)->where('status',1)->first();
    //Check if the user exists
        if (isset($user)) {
               //Create Password Reset Token
        DB::table('password_resets')->insert([
            'email' => $request->email,
            'token' => Str::random(60),
            'created_at' => Carbon::now()
        ]);

        $tokenData = DB::table('password_resets')
            ->where('email', $request->email)->first();

        if ($this->sendResetEmail($request->email, $tokenData->token)) {
            return redirect()->back()->with('success', trans('A reset link has been sent to your email address.'));
        } else {
            return redirect()->back()->withErrors(['error' => trans('A Network Error occurred. Please try again.')]);
        }
           
        }else{
             return redirect()->back()->withErrors(['email' => trans('Email does not exist')]);
        }

     
           
    }

//     private function sendResetEmail($email, $token)
// {
       
//         $user = DB::table('users')->where('email', $email)->select('name', 'email')->first();
        
//         $link = url('/') . '/change-password/' . $token . '?email=' . urlencode($user->email);

//             try {
//           // send reset in email  
//                      $data['title'] = " Reset Password";
//                         $data['FromEmail'] = "sandman";
//                         $data['subject'] = 'Password Reset Link';
//                         $data['name'] = $user->name;
//                         $data['link'] =   $link;
//                         Mail::to([$user->email])->send(new UserResetPassword($data));
            
               
//          // email end
//                 return true;
//             } catch (\Exception $e) {
//                 return false;
//             }
// }

private function sendResetEmail($email, $token)
{
    $user = DB::table('users')->where('email', $email)->select('name', 'email')->first();
    
    $link = url('/') . '/change-password/' . $token . '?email=' . urlencode($user->email);

    try {
        // send reset in email  
        $data['title'] = " Reset Password";
        $data['From'] = "sandman.galley"; 
        $data['subject'] = 'Password Reset Link';
        $data['name'] = $user->name;
        $data['link'] =   $link;
        Mail::to([$user->email])->send(new UserResetPassword($data));

        // email end
        return true;
    } catch (\Exception $e) {
        return false;
    }
}


public function getUserResetPasswordForm(Request $request ) {
     $token = $request->route()->parameter('token');

        return view('front.confirm-reset-password')->with(
            ['token' => $token, 'email' => $request->email]
        );
   
}


public function resetPassword(Request $request)
{
   
     $request->validate([
          'new_password' => 'required|confirmed|min:6|',
           'new_password_confirmation' => 'required|min:6',
           'token' => 'required',
        ]);
   
    $password = $request->new_password;
// Validate the token
    $tokenData = DB::table('password_resets')->where('token', $request->token)->first();
// Redirect the user back to the password reset request form if the token is invalid
    if (!$tokenData)  return redirect()->back()->with('error','Token is invalid please request a new reset link.');;

    $user = User::where('email', $tokenData->email)->first();

    if (!$user){
      return redirect()->back()->with(['error' => 'Email not found']);  
    } 

    $user->password = Hash::make($password);
    $user->save(); 
    Auth::login($user);

    //Delete the token
    DB::table('password_resets')->where('email', $user->email)
    ->delete();
     return redirect('/login')->with('success','Password Succesfully Reset.');
   
    // //Send Email Reset Success Email
    // if ($this->sendSuccessEmail($tokenData->email)) {
    //     return view('index');
    // } else {
    //     return redirect()->back()->withErrors(['email' => trans('A Network Error occurred. Please try again.')]);
    // }

}


    
 
}