<?php

namespace App\Http\Controllers;

use \App\Models\User;
use \App\Models\Category;
use \App\Models\Product;
use \App\Models\Color;
use \App\Models\Size;
use \App\Models\Order;
use \App\Models\Banner;
use \App\Models\ProductSize;
use \App\Models\ProductImage;
use \App\Models\UserAddress;
use App\Models\ProductSizeUsd;
use \App\Models\OrderDetail;
use \App\Models\Subcategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Picqer\Barcode\BarcodeGeneratorPNG;
use Maatwebsite\Excel\Facades\Excel;
use App\Imports\ImportDc;
use App\Exports\ExportDc;
use DB;
use Illuminate\Support\Str;
use Auth;
use \App\Mail\SendPdfMail;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use PDF;
 use Mail;
 use Illuminate\Support\Facades\Storage;
use Intervention\Image\ImageManagerStatic as Image;

use Illuminate\Support\Facades\Http;
class ProductController extends Controller
{
      public function __construct()
    {
        $this->middleware('auth');
    }
   
   
    

    
    public function addProduct()
    {
        $pageName = 'Course';
        $method = 'Add New';
    
        $categories = Category::where('status', 1)->pluck('name', 'id');
        $colors = Color::where('status', 1)->pluck('name', 'id');
        $sizes = Size::where('status', 1)->pluck('name', 'id');
    
        return view('admin.product.add', compact('categories', 'colors', 'sizes'));
    }

    
    // public function listProduct(){
        
    //     $result =Product::select('products.*');
    //     if(isset($_GET['category']) && !empty($_GET['category'])){
    //         $result=$result->where('products.category_id','=',$_GET['category']);
    //         $selectStatus = $_GET['category'];
    //     }
    //       if(isset($_GET['sku_no']) && !empty($_GET['sku_no'])){
    //         $result=$result->where('products.sku_no','=',$_GET['sku_no']);
    //     }
    //      if(isset($_GET['name']) && !empty($_GET['name'])){
    //         $search = $_GET['name'];
    //         $result->where(function($query) use ($search){
    //             $query->where('products.name', 'LIKE', '%'.$search.'%');
    
    //         });
    //     }   
        
    //     $result=$result->orderBy('products.id','desc')->get();        

    //     $total=0;
        
    //     $page=0;
    //     $categories =Category::where('status',1)->get();
    //     return view('admin.product.list',compact('result','total','page','categories'));
    // }
    
    public function listProduct(Request $request){
        
      $orderCount = Order::where('order_number', 'like', 'ORD%')->where('order_status', '!=', 'Cancelled')->count(); 
      $orderCountforApp = Order::where('order_number', 'not like', 'ORD%')->where('order_status', '!=', 'Cancelled')->count();
      $orderdiscount = Order::where('order_status', '!=', 'Cancelled')->whereNotIn('discount_amount', ['0', '0.0'])->count();
      $orderamountWeb = Order::where('order_number', 'like', 'ORD%')->where('order_status', '!=', 'Cancelled')->sum('order_amount_after_discount'); 
      $orderamountApp = Order::where('order_number', 'not like', 'ORD%')->where('order_status', '!=', 'Cancelled')->sum('order_amount_after_discount'); 
      $totaldiscountamount = Order::where('order_status', '!=', 'Cancelled')->sum('discount_amount'); 

    $result = Product::select('products.*');

    if($request->has('category') && !empty($request->input('category'))){
        $result = $result->where('products.category_id', $request->input('category'));
        $selectStatus = $request->input('category');
    }

    if($request->has('sku_no') && !empty($request->input('sku_no'))){
        $result = $result->where('products.sku_no', $request->input('sku_no'));
    }

    if($request->has('name') && !empty($request->input('name'))){
        $search = $request->input('name');
        $result = $result->where(function($query) use ($search){
            $query->where('products.name', 'LIKE', '%'.$search.'%');
        });
    }   

    $result = $result->orderBy('products.id','desc')->paginate(10); // Paginate with 10 items per page

    $categories = Category::where('status',1)->get();
    
    return view('admin.product.list', compact('result', 'categories','orderCount','orderCountforApp','orderdiscount','orderamountWeb','orderamountApp','totaldiscountamount'));
}

    
    
    
      public function showIndexPpage($slug= NULL){
        
        $result =Product::select('products.*')->with('colors');
        if(isset($_GET['category']) && !empty($_GET['category'])){
            $result=$result->where('products.category_id','=',$_GET['category']);
            $selectStatus = $_GET['category'];
        }
           if(isset($_GET['sku_no']) && !empty($_GET['sku_no'])){
            $result=$result->where('products.sku_no','=',$_GET['sku_no']);
        }
         if(isset($_GET['name']) && !empty($_GET['name'])){
            $search = $_GET['name'];
            $result->where(function($query) use ($search){
                $query->where('products.name', 'LIKE', '%'.$search.'%');
    
            });
        }   
        
        if($slug == 'new'){
            $result=$result->orderBy('products.is_new','desc')->get();   
        }else if($slug == 'black'){
            $result=$result->orderBy('products.blackdress','desc')->get();   
        }else{
            $result=$result->orderBy('products.party_wear','desc')->get();   
        }
             

        $total=0;
        
        $page=0;
        $categories =Category::where('status',1)->get();
        return view('admin.product.index',compact('result','total','page','categories','slug'));
    }
    
    
    
    
     public function viewProduct($id){
          $result = Product::where(['id'=>$id])->with('images')->first();
        $colors =Color::where('status',1)->pluck('name','id');
        $sizes =Size::where('status',1)->pluck('name','id');
        $categories =Category::where('status',1)->pluck('name','id');
        
        $totalPiecesSold = OrderDetail::where('product_id', $id)
    ->whereNotIn('status', ['cancelled']) 
    ->sum('quantity');

        
        return view('admin.product.view',compact('result','categories','colors','sizes','totalPiecesSold'));
    }
    
    
     public function chkSkuExist(Request $request){
        $sku = $request->sku;
        $result =Product::where('products.sku_no',$sku)->first();
        if(!empty($result)){
            return 1;
        }else{
            return 0;
        }
    }
    
        public function addMoreModuleQuestionSection(Request $request){
        $counter = $request->counter;
        $sizes =Size::where('status',1)->pluck('name','id');
       return view('admin.product.moduleQuestionSection',compact('counter','sizes'));
    } 
    
    
     public function addMoreModuleQuestionSectionUsd(Request $request){
        $counter = $request->counter;
        $sizes =Size::where('status',1)->pluck('name','id');
       return view('admin.product.moduleQuestionSectionUsd',compact('counter','sizes'));
    } 
 
      public function saveProduct(Request $request){
        
         $input = $request->all();
      $request->validate([
            'name' => 'required',
            'sku_no'=>'required',
            'category_id'=> 'required',
             'color_id'=> 'required',
            'how_to_use'=>'required',
            'description'=>'required',
            'front_image'=>'required',
            'hover_image'=>'required',
            // 'images[]'=>'required',
            // 'us_link'=>'required',
            // 'canada_link'=>'required',
            
            
            
        ],[
            'name.required' => 'Please Enter Name',
            'sku_no.required' => 'Please Enter SKU No',
             'category_id.required' => 'Please Select Category',
             'color_id.required' => 'Please Select Color',
             'how_to_use.required'=>'Please Enter How to Use',
             'description.required'=>'Please Enter Description',
             'front_image.required'=>'Please Select Front Image',
             'hover_image.required'=>'Please Select Hover Image',
            //  'us_link.required'=>'Please Enter US link',
            //  'canada_link.required'=>'Please Enter CANADA link',
            //  'images[].required'=>'Please Select Images',
        ]);
        

        $front_image = $request->file('front_image');
        $hover_image = $request->file('hover_image');
        $data = new Product;
        $data->name = $request->name;
        $data->category_id = $request->category_id;
        if(!empty($request->color_id)){
            $data->color_id = $request->color_id;
        }else{
            $data->color_id = 0;
        }
        if(!empty($request->sub_category_id)){
        $data->sub_category_id = $request->sub_category_id;
        }
        
        $data->sku_no = $request->sku_no;
        // $data->canada_link = $request->canada_link;
        $data->us_link = $request->us_link;
         
        
        $data->description = $request->description;
        
        $data->material = $request->material;
        $data->weight = $request->weight;
        $data->package_diamention = $request->package_diamention;
        $data->manufacturer = $request->manufacturer;
        
        // $data->long_description = $request->long_description;
        $data->how_to_use = $request->how_to_use;
          if(!empty($front_image)){
                $frontImage = $front_image;
                $frontImageName = time().rand(1,50).'.'.$frontImage->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/product');
                $frontImage->move($destinationPath, $frontImageName);
                $imagePath = 'public/uploads/product/'.$frontImageName;
                $data->front_image=$imagePath;
            }
            
              if(!empty($hover_image)){
                $hoverImage = $hover_image;
                $hoverImageName = time().rand(1,50).'.'.$hoverImage->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/product');
                $hoverImage->move($destinationPath, $hoverImageName);
                $imagePath = 'public/uploads/product/'.$hoverImageName;
                $data->hover_image=$imagePath;
            }
            
             
      
        
        if($data->save()){
             if(!empty($request->images)){
                     foreach($request->images as $image)
                        {   
                            $pro_image = new ProductImage();
                            $imageName = time().rand(1,50). ".". $image->extension();
                            $destinationPath = public_path('/uploads/product');
                            $image->move($destinationPath, $imageName);
                             $imagePath = 'public/uploads/product/'.$imageName;
                           
                            $pro_image->image = $imagePath;
                            $pro_image->product_id = $data->id;
                            $pro_image->save();
                          
                        }
	           }
	          if (!empty($request->modules)) {
            foreach ($request->modules as $k => $modQues) {
                if (!empty($modQues['size_id'])) {
                    $proSizes = new ProductSize;
                    $proSizes->product_id = $data->id;
                    $proSizes->size_id = $modQues['size_id'];
                    $proSizes->price = $modQues['price'];
                    $proSizes->sell_price = $modQues['sell_price'];
                    // $proSizes->price_usd = $modQues['price_usd'];
                    // $proSizes->sell_price_usd = $modQues['sell_price_usd'];
                    $proSizes->stock = $modQues['stock'];
                    $proSizes->save();
            
                }
            }
        }
		  
            return redirect()->route('admin.list.product')->with('success','New Product Created successfully');
        } else {
            return redirect()->back()->with('failed','New Product Created Faild. Please try again letter');
        }
    }
    
    
    
   
    
        public function updateProductStatus($id)
{
    $product = Product::find($id);

    if (!$product) {
        return redirect()->route('admin.list.product')->with('error', 'Product not found!');
    }

    $product->status = !$product->status; // Toggle the status

    if ($product->save()) {
        $statusText = $product->status ? 'Activated' : 'Deactivated';
        return redirect()->route('admin.list.product')->with('success', "Product $statusText successfully!");
    } else {
        return redirect()->route('admin.list.product')->with('error', 'Failed to update product status.');
    }
}
   
    
    
   public function deleteProduct($id){
    $product = Product::find($id);

    if(!$product){
        return redirect()->route('admin.list.product')->with('failed', 'Product not found');
    }

    // Delete product images
    ProductImage::where('product_id', $id)->delete();

    // Delete product sizes
    ProductSize::where('product_id', $id)->delete();

    // Delete product main entry
    $product->delete();

    return redirect()->route('admin.list.product')->with('success', 'Product deleted successfully');
}


    
    
     public function fetchSubcategories(Request $request)
    {
       
        $data['subcat'] = Subcategory::where("cat_id",$request->cat_id)->get(["name", "id"]);
       
        return response()->json($data);
    }

    
    
    public function editProduct($id = NULL){
    $pageName = 'Product';
    $method = 'Edit';
    $result = Product::where(['id' => $id])->with('images')->first();
    $colors = Color::where('status', 1)->pluck('name', 'id');
    $sizes = Size::where('status', 1)->pluck('name', 'id');
    $categories = Category::where('status', 1)->pluck('name', 'id');
    $subCategories = SubCategory::where('cat_id', $result->category_id)->pluck('name', 'id');
    
    return view('admin.product.edit', compact('pageName', 'method', 'result', 'categories', 'colors', 'sizes', 'subCategories'));
}

    
    
    
      public function updateProduct(Request $request,$id=NULL){
        $input = $request->all();
        $request->validate([
            'name' => 'required',
            'sku_no'=>'required',
            'category_id'=> 'required',
            
        ],[
            'name.required' => 'Please Enter Name',
            'sku_no.required' => 'Please Enter Email',
            'category_id.required' => 'Please Select Category',
        ]);
        
        $front_image = $request->file('front_image');
        $hover_image = $request->file('hover_image');
        $size_chart = $request->file('size_chart');
        $data = Product::where(['id'=>$id])->first();
        $data->name = $request->name;
        $data->category_id = $request->category_id;
        if(!empty($request->color_id)){
            $data->color_id = $request->color_id;
        }else{
            $data->color_id = 0;
        }
        
        if(!empty($request->sub_category_id)){
        $data->sub_category_id = $request->sub_category_id;
        }
        
        $data->sku_no = $request->sku_no;
        $data->how_to_use = $request->how_to_use;
        $data->description = $request->description;
         $data->us_link = $request->us_link;
        $data->material = $request->material;
        $data->weight = $request->weight;
        $data->package_diamention = $request->package_diamention;
        $data->manufacturer = $request->manufacturer;
        //   $data->canada_link = $request->canada_link;
         if(!empty($front_image)){
                $frontImage = $front_image;
                $frontImageName = time().rand(1,50).'.'.$frontImage->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/product');
                $frontImage->move($destinationPath, $frontImageName);
                $imagePath = 'public/uploads/product/'.$frontImageName;
                $data->front_image=$imagePath;
            }
            
              if(!empty($hover_image)){
                $hoverImage = $hover_image;
                $hoverImageName = time().rand(1,50).'.'.$hoverImage->getClientOriginalExtension();
                $destinationPath = public_path('/uploads/product');
                $hoverImage->move($destinationPath, $hoverImageName);
                $imagePath = 'public/uploads/product/'.$hoverImageName;
                $data->hover_image=$imagePath;
            }
            
             
        if($data->save()){

                if(!empty($request->images)){
                     foreach($request->images as $image)
                        {   
                            $pro_image = new ProductImage();
                            $imageName = time().rand(1,50). ".". $image->extension();
                            $destinationPath = public_path('/uploads/product');
                            $image->move($destinationPath, $imageName);
                             $imagePath = 'public/uploads/product/'.$imageName;
                           
                            $pro_image->image = $imagePath;
                            $pro_image->product_id = $data->id;
                            $pro_image->save();
                          
                        }
	           }
	           
	           
    	       if(!empty($request->modules)){
    			    foreach ($request->modules as $k => $modQues) {
    			        $resultQueAns	=	ProductSize::where("id",$k)->where('product_id',$id)->first();
    			        if(!empty($resultQueAns)){
			                $proSizes = ProductSize::find($k);
			                $proSizes->size_id = $modQues['size_id'];
                            $proSizes->price = $modQues['price'];
                            $proSizes->sell_price = $modQues['sell_price'];
                            $proSizes->stock = $modQues['stock'];
                            $proSizes->save();
    			        }else{
    			            if(!empty($modQues['size_id'])){
        			            $proSizes = new ProductSize;
        			            $proSizes->product_id = $data->id;
                                $proSizes->size_id = $modQues['size_id'];
                                $proSizes->price = $modQues['price'];
                                $proSizes->sell_price = $modQues['sell_price'];
                                 $proSizes->price_usd = $modQues['price'];
                                $proSizes->sell_price_usd = $modQues['sell_price'];
                                $proSizes->stock = $modQues['stock'];
            			        $proSizes->save();
    			           }
    			        }
    			           
    			    }
    		    }
         
           return redirect()->route('admin.list.product')->with('success','Product Updated successfully');
        } else {
            return redirect()->back()->with('failed','New Modules Created Faild. Please try again letter');
        }
    }
    
     // delete product option images 
     public function deleteOptionImage($id)
    {
        try{
           
            $product_image = ProductImage::findOrFail($id);
            if(file_exists( public_path('/uploads/product/').$product_image->image )){
                 unlink(public_path('/uploads/product/').$product_image->image);
             }

            $product_image->delete();
          return redirect()->back()->with('success',' Product Image deleted');  
        } catch(\Exception $ex) {
            return response()->json([
                "success" => false,
                "code" => 400,
                'errors' => $ex->getMessage(),
            ]);
        }
    }
    
    
    public function deleteQuestionAnswer(Request $request){
       ProductSize::where('id',$request->id)->delete();
       return true;
    }
    
    
    public function updateLearningModuleStatus($id = 0, $status=NULL){
        $data = Product::where(['id'=>$id])->first();
        $data->is_active = $status;
       
        if($data->save()){
            return redirect('admin/new-learning-module#learningModules')->with('success','Status Updated successfully');
        } else {
            return redirect()->back()->with('failed','New Employee Coupon Faild. Please try again letter');
        }
    }
    
     public function viewLearningModule($id = NULL){
        $pageName = 'Product';
        $method = 'view';
         $result = Product::where(['id'=>$id,'is_deleted'=>0])->with('modules')->first();
        $companyes =User::where('is_deleted',0)->where('type',config('global.LEARNING_PARTNER'))->where('status',1)->pluck('name','id');
        $getLastId =     ProductModule::where('product_id',$result->id)->select('id')->orderBy('id','desc')->first();   
        //echo '<pre/>';print_r($result);die;
        $questionData = ProductQuestion::where('product_id',$id)->where('product_module_id',0)->get();
        return view('admin.product.view',compact('pageName','method','result','companyes','questionData','getLastId'));
    }
    
    
    public function markBlackdress(Request $request,$slug=NULL)
    {
        $selectedProductIds = $request->input('selectedProducts', []);

        // Update the 'blackdress' column for selected products
        if($slug == 'black'){
            Product::whereIn('id', $selectedProductIds)
               ->update(['blackdress' => 1]);
        }else if($slug == 'new'){
            Product::whereIn('id', $selectedProductIds)
               ->update(['is_new' => 1]);
        }else{
            Product::whereIn('id', $selectedProductIds)
               ->update(['party_wear' => 1]);
        }
        
        $banner = Banner::where('slug',$slug)->first();
        // Redirect back with a success message
        return redirect()->route('banner.edit',$banner->id)->with('success', 'Product Added Successfully.');
    }
    
  
}
