<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\Models\Coupon;
use \App\Models\Product;
use \App\Models\Booking;
use \App\Models\Review;
use \App\Models\HelpTicket;
use DB;
use Auth;
use Illuminate\Support\Str;


class SponsorController extends Controller
{
    /**
     * Company Login View page
     */
    public function sponsorLogin(){    
        return view('sponsor.login');
    }
    
    
     /**
     * Company Login Submit
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function sponsorLoginSubmit(Request $request)
    {   
       // echo 23;die;
        $input = $request->all();
     
        $this->validate($request, [
            'email' => 'required|email',
            'password' => 'required',
        ]);
     
        if(auth()->attempt(array('email' => $input['email'], 'password' => $input['password'],'status'=>1,'type'=>config('global.VENDOR'))))
        {
            if (auth()->user()->type == config('global.VENDOR')) {
                return redirect()->route('sponsor.home');
            }else{
                return redirect()->route('login')
                ->with('error','Email-Address And Password Are Wrong.');
            }
        }else{
            return redirect()->route('login')
                ->with('error','Email-Address And Password Are Wrong.');
        }
          
    }
    
    
    public function availableCoupons(Request $request)
    {
        $allAvailableCoupons = Coupon::leftJoin('products','products.id','=','coupons.course_id')->where('coupons.sponsor_id',Auth::user()->id)
                                        ->where('coupons.is_active',1)
                                        ->select("coupons.*",'products.name as course_name')
                                        ->get();
         return view('sponsor.available_coupon',compact('allAvailableCoupons'));
        
    }
    
    
    public function usedCoupons(Request $request)
    {
        $allUsedCoupons = Coupon::leftJoin('products','products.id','=','coupons.course_id')->where('coupons.sponsor_id',Auth::user()->id)
                                        ->where('coupons.is_active',0)
                                        ->select("coupons.*",'products.name as course_name')
                                        ->get();
        if(!empty($allUsedCoupons)){
            foreach($allUsedCoupons as $cData){
                    $getUsedCouponCourse = Booking::leftJoin('users','users.id','=','bookings.user_id')->where('bookings.coupon_id',$cData->id)
                                                    ->select('bookings.user_id','users.name','bookings.result')->first();
                                                //    echo '<pre/>';print_r($getUsedCouponCourse);die;
                    $cData->user_name = $getUsedCouponCourse->name;
                    $cData->result = $getUsedCouponCourse->result;
                }
        }
         return view('sponsor.used_coupon',compact('allUsedCoupons'));
        
    }
    
    
     public function addQuery(){
        $pageName = 'Query';
        $method = 'Add New';
      
       
           
        $result=HelpTicket::orderBy('id','desc')->where('user_id',Auth::user()->id)->get();
        $total=0;
        
        $page=0;
        return view('sponsor.add_query',compact('pageName','method','result','total','page'));
    }
    
    public function SavePartnerQuery(Request $request){
        $data = new HelpTicket;
        $data->message = $request->message;
        $data->user_id = Auth::user()->id;
        $data->status = 'in_process';
      
        if($data->save()){
           
            return redirect()->route('sponsor.home')->with('success','Your Query Is Submitted Successfully');
        } else {
            return redirect()->back()->with('failed','New Vendor Created Faild. Please try again letter');
        }
    }
    
    
    public function listCourse(Request $request)
    {
       if(Auth::user()->id){
           $coursesData  = Product::leftJoin('users','users.id','=','products.company_id')
                                    ->with('reviews')
                                    ->where('products.is_active',1)
                                    ->where('products.is_deleted',0)
                                    ->where('products.is_deleted',0)->select('products.id','products.name as course_name','products.description','products.cost','products.image','products.course_type','users.name as learning_partner_name','products.total_modules','products.average_rating')->get();
           if($coursesData){
               foreach($coursesData as $cData){
                    $availableCoupons = Coupon::where('course_id',$cData->id)->where('sponsor_id',Auth::user()->id)->where('is_active',1)->count();
                    $usedCoupons =      Coupon::where('course_id',$cData->id)->where('sponsor_id',Auth::user()->id)->where('is_active',0)->count();
                    $cData->available_coupons = $availableCoupons;
                    $cData->used_coupons = $usedCoupons;
                    $cData->five_star_rating = Review::where('course_id',$cData->id)->where('rating',5)->count();
                    $cData->four_star_rating = Review::where('course_id',$cData->id)->where('rating',4)->count();
                    $cData->three_star_rating = Review::where('course_id',$cData->id)->where('rating',3)->count();
                    $cData->two_star_rating = Review::where('course_id',$cData->id)->where('rating',2)->count();
                    $cData->one_star_rating = Review::where('course_id',$cData->id)->where('rating',1)->count();
               }
               return view('sponsor.course_list',compact('coursesData'));
           }else{
               return $this->sendError('Courses Not Exist In Database.Please add courses first.');
           }
       }else{
           return $this->sendError('User Not Exist In Database');
       }
       
    }
    
}
