@extends('admin.layouts.app')
@section('title','Edit Category')

@section('content')

   <div class="main-content d-flex justify-content-center align-items-center">
             
            <div class="container-fluid">
                <div class="row">
                    <div class="col-lg-12">
                        <!-- Base Control -->
                        <div class="form-element base-control mb-30">
                            <h4 class="font-20 mb-4">Edit Banner</h4>

                            <!-- Form -->
                            <form method="post" action="{{route('banner.update',$data->id)}}" enctype="multipart/form-data">
@csrf
                                <!-- Form Group -->
                                <div class="form-group mb-4">
                                    <label for="email1" class="mb-2 black bold">Banner Name</label>
                                    <input type="text" id="name" value="{{$data->name}}" class="theme-input-style @error('name') is-invalid @enderror " name="name" >
                                     @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <!-- End Form Group -->

                                <!-- Form Group -->
                                <div class="form-group mb-4">
                                    <label for="password1" class="mb-2 black bold">Banner Image</label>
                                    <input type="file" name="image" class="theme-input-style" id="image" >
                                     @if($data->image)
                                            <img src="{{env('APP_URL')}}{{$data->image}}" height="50px" width="50px"/>
                                        @endif
                                </div>
                                   <div class="col-md-3">
                                        <div class="form-group mb-4">
                                       <label for="text_on_banner">Show Text On Banner:</label>
                                           <input id="text_on_banner" name="text_on_banner" type="checkbox" value="1" class="" {{ $data->text_on_banner == 1 ? 'checked' : '' }}>
                        
                                         
                                        </div>
                                    </div>
                                    @if($data->slug == 'new' || $data->slug == 'black' || $data->slug == 'party')
                                     <h4 class="pt-2 mb-4">Product List</h4>
               <div class="product-grid pt-2">
                            <div class="row">
                                 @if(count($result) > 0)
                             @foreach($result as $product)
                                <div class="col-xl-2 col-lg-3 col-md-4 col-sm-6 col-12">
                                    <!-- Product Grid Item -->
                                    <div class="product-grid-item mb-30">
                                        <div class="product-img mb-3">
                                             <a href="{{route('admin.view.product',$product->id)}}">
                                                <?php //echo '<pre/>';print_r($product->colors[0]->sizes[0]);die;?>
                                                 @if($product->colors[0]->front_image)
                                                    <img src="{{env('APP_URL')}}{{$product->colors[0]->front_image}}" class="" height="150px" width="100px"/>
                                                @endif
                                             </a>
                                        </div>
                                        <div class="product-content">
                                            <h6 class="mb-10">@if(!empty($product->colors[0]->sizes))₹{{$product->colors[0]->sizes[0]->sell_price}}@endif</h6>
                                             <a href="{{route('admin.view.product',$product->id)}}">
                                                <p class="black">{{$product->name}}</p>
                                             </a>
                                             <a href="{{route('admin.view.product',$product->id)}}">
                                                <p class="black">{{$product->sku_no}}</p>
                                             </a>
                                        </div>
                                    </div>
                                    <?php //die;?>
                                    <!-- End Product Grid Item -->
                                </div>
                            @endforeach
                         @endif
                         
                          
                         
                            </div>
                        </div>
       @endif
                               
                                <!-- Button Group -->
                                <div class="button-group pt-1">
                                    <button type="submit" class="btn long">Submit</button>
                                    <button type="reset" class="link-btn bg-transparent ml-3 soft-pink">Cancel</button>
                                    @if($data->slug == 'new' || $data->slug == 'black' || $data->slug == 'party')
                                    <a href="{{route('showIndexPpage',$data->slug)}}"  class="link-btn bg-transparent ml-3 soft-pink">Add Product & Edit Product</a>
                                    @endif
                                </div>
                                <!-- End Button Group -->
                            </form>
                            <!-- End Form -->
                        </div>
                        <!-- End Base Control -->

                       
                    </div>
                </div>
            </div>            
                    
         </div>
@endsection
