@extends('admin.layouts.app')
                   
@section('content')
   <div class="wrapper wrapper-content animated fadeInRight">
           
           
            <div class="row">
                <div class="col-lg-12">
                    <div class="ibox ">
                        <div class="ibox-title">
                            <h5>{{$pageName}} List </h5>
                            
                        </div>
                        <div class="ibox-content">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="table_id">
                                    <thead>
                                    <tr>

                                      <th width="10%">Image  </th>
                                        <th width="10%">User Name </th>
                                         <th width="10%">Email</th>
                                        <th width="10%">Mobile</th>
                                      
                                        <th width="10%">Status</th>
                                        <th width="30%">Action</th>
                                      
                                    </tr>
                                    </thead>
                                    <tbody>

                                    @foreach($result as $key=>$val)
                                  
                                   
                                    <tr>
                                         <td>
                                             @if(!empty($val->image))
                                             <img src="{{env('APP_URL')}}{{ $val->image }}" class="img-rounded" height="70px;" >
                                             @endif</td>
                                        <td>{{$val->name}}</td>
                                      
                                        <td>{{$val->email}}</td>
                                        <td>{{$val->phone_number}}</td>
                                       
                                         
                                             <td>
							@if($val->status	== 1)
								<span class="label label-success" >Activated </span>
							@else
								<span class="label label-warning" >Deactivated </span>
							@endif
						</td>
					
					
                              
        <td>
                        @if($val->status == 1)
							
								{!! Html::decode(link_to_route('admin.status.employee','<i class="fa fa-ban"></i>',[$val->id, 0],['class'=>'btn btn-success','title'=>'Click To Deactivate' ,'onclick'=>'return changeStatus();'])) !!}
							@else
							
								
									{!! Html::decode(link_to_route('admin.status.employee','<i class="fa fa-check"></i>',[$val->id, 1],['class'=>'btn btn-success','title'=>'Click To Activate','onclick'=>'return changeStatus();'])) !!}
							@endif 
                            {!! Html::decode(link_to_route('admin.edit.employee','<i class="fa fa-pencil"></i>',[$val->id],['class'=>'btn btn-primary','title'=>'Edit'])) !!}  
                           <a href="{{ route('admin.view.employee',$val->id)}}" class="btn btn-primary" title="View"><i class="fa fa-eye"></i></a>   
                            
                              <a href="#myModal" data-toggle="modal" class="btn btn-success gradient-blue btn-lg mt-10 right15" onclick="assignUserId({{$val->id}})">
                                                    <span>Assign Course</span>
                                                </a>
                          
                            
                                    </td>
                                    
                                    </tr>
                                    @endforeach
                                   
                                    
                                    </tbody>
                                </table>
                                
                            </div>

                        </div>
                    </div>
                </div>

            </div>
</div>

<div aria-hidden="true" role="dialog" tabindex="-1" id="myModal" class="modal fade" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                            <h4 class="modal-title">Assign Package</h4>
                        </div>
                        <div class="modal-body">
                            {!! Form::open(['role' => 'form','route' => "admin.assignCourse",'method' => 'post', 'files' => true]) !!}
                            {{ Form::hidden('user_id','', ['class'=>'form-control user_id']) }}
                                <div class="form-group packageView">
                                   
                                </div>
                                
                               
                                <button type="submit" class="btn btn-primary">Submit</button>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
             <script>
                 function assignUserId(id){
                    $('.user_id').val(id);
                     $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                         
                      $('.packageView').empty();
                
                      
                
                        $.ajax({
                        type:'POST',
                        url:"{{ route('ajaxRequest.courseField') }}",
                        data:{user_id:id},
                        success:function(data){
                            //alert(data);

                            $('.packageView').empty().append(data);
                           
                        }
                        });       
                   
               
           }
           </script>
       
@endsection
