@extends('admin.layouts.app')
@section('title','All Banners')
@section('content')

  <div class="main-content">
                <div class="container-fluid">
        <div class="row">
          <div class="col-12">
              <div class="card mb-30">
                   <div class="card-body pt-30">
                                   
                                     <table>
                                       <tbody><tr><td> <h4 class="font-20 ">Slider List</h4></td><td><a href="{{route('slider.add')}}" class="btn long">Add new Slider</a></td></tr>
                                   </tbody></table>
                                </div>
                              
              <!-- /.card-header -->
              <div class="table-responsive">
                <table class="text-nowrap bg-white dh-table">
                  <thead>
                  <tr>
                    <th>Logo</th>
                    <th>Name</th>
                    <th>Banner type</th>
                    <th>Banner For</th>
                    <th>Order</th>
                    <th>Status </th>
                    <th>Action </th>
                  
                  </tr>
                  </thead>
                  <tbody>
                    @if(count($result) > 0)
                    @foreach($result as $banner)
                  <tr>
                      <td>
                          @if($banner->image)
                                            <img src="{{env('APP_URL')}}{{$banner->image}}" height="50px" width="50px"/>
                                        @endif
                      </td>
                    <td>{{$banner->name}}</td>
                    <td>{{ ucfirst($banner->banner_type)}}</td>
                    <td>{{ ucfirst($banner->banner_for)}}</td>
                    <td>{{ ($banner->sort_order)}}</td>
                     <td>
                        @if($banner->status == 1)
                     <button type="button" class="btn btn-success  btn-sm"  title="Click To Deactivate"  data-value="block">
                      Active
                     </button>
                     @else
                        <button type="button"class="btn btn-danger  btn-sm" title="Click To Activate" data-value="active">
                          InActive
                     </button>
                     @endif

                     </td>
                     <td>


                         {!! Html::decode(link_to_route('slider.edit','<i class="icofont-edit"></i>',[$banner->id],['class'=>'btn btn-primary','title'=>'Edit'])) !!}  
                     </td>
                    
              
                    
                  </tr>

    
                  @endforeach
                  @endif
              
               
                  </tbody>
                  
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
          </div>
          <!-- /.col -->
        </div>
        <!-- /.row -->
      </div>
      <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>


@endsection
