@extends('admin.layouts.app')

@section('content')
<div class="wrapper main-wrapper row" style=''>

                <div class='col-xs-12'>
                    <div class="page-title">

                        <div class="pull-left">
                            <!-- PAGE HEADING TAG - START -->
                            <h1 class="title">Doctor Profile</h1>
                            <!-- PAGE HEADING TAG - END -->
                        </div>

                    </div>
                </div>

                <div class="clearfix"></div>
                <!-- MAIN CONTENT AREA STARTS -->

                <div class="col-lg-4">
                    <section class="box ">
                        <div class="content-body p">
                            <div class="row">
                                <div class="doctors-list v2  relative">
                                    <div class="doctors-head relative text-left mb-0">
                                        <div class="doc-img img-circle">
                                             <img src="{{env('APP_URL')}}{{$data->image}}" class="img-thumbnail center-block" alt=""/>
                                            <div class="stutas"></div>
                                        </div>
                                        <h3 class="header relative bold">{{$data->name}}</h3>
                                        <h5 class="boldy">{{$data->phone_number}}</h5>
                                        <p class="desc relative mb-15">{{$data->brief}}</p>
                                        <!--<div class="doc-rating mb-30">-->
                                        <!--    <i class="fa fa-star"></i>-->
                                        <!--    <i class="fa fa-star"></i>-->
                                        <!--    <i class="fa fa-star"></i>-->
                                        <!--    <i class="fa fa-star"></i>-->
                                        <!--    <i class="fa fa-star"></i>-->
                                        <!--    <span>4.8</span>-->
                                        <!--</div>-->

                                        <div class="email-div">
                                            <i class="fa fa-envelope f-s-14 mr-10"></i><span>Email</span>
                                            <a href="#" class="blue-text">
                                                <h5 class="text-info">{{$data->email}}</h5>
                                            </a>
                                            
                                        
                                            
                                            <a href="{{route('doctor.edit',$data->id)}}" type="button" class="btn btn-success btn-icon btn-lg mt-10 right15">
                                                <i class="fa fa-pencil f-s-14"></i> &nbsp; <span>Edit Profile</span>
                                            </a>
                                        </div>  
                                    </div>
                                    
                                </div>
                               
                            </div>
                        </div>
                    </section>
                </div>

                <div class="col-lg-8 col-md-12">
                
                    <div class="row">
                        <div class="col-xs-12 col-md-6">
                            <section class="box ">
                                <header class="panel_header">
                                    <h2 class="title pull-left">DCs</h2>
                                    <div class="actions panel_actions pull-right">
                                        <a class="box_toggle fa fa-chevron-down"></a>
                                        <a class="box_setting fa fa-cog" data-toggle="modal" href="#section-settings"></a>
                                        <a class="box_close fa fa-times"></a>
                                    </div>
                                </header>
                                <div class="content-body">    
                                    <div class="row align-items-center flex">
                                        <div class="col-xs-12 text-center">
                                            
                                            <img src="../data/hos-dash/badge.png" style="max-width:85px" alt="">
                                            <h4 class="boldy">{{$dcCount}}</h4>
                                            <div class="mt-10 text-center">
                                                <a href="{{ route('import-dc-view',$data->id)}}" type="button" class="btn btn-success gradient-blue btn-lg mt-10 right15">
                                                    <span>Upload Dc</span>
                                                </a>
                                            </div>
                                            
                                            
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                        <div class="col-xs-12 col-md-6">
                            <section class="box ">
                                <header class="panel_header">
                                    <h2 class="title pull-left">Social Media Info</h2>
                                    <div class="actions panel_actions pull-right">
                                        <a class="box_toggle fa fa-chevron-down"></a>
                                        <a class="box_setting fa fa-cog" data-toggle="modal" href="#section-settings"></a>
                                        <a class="box_close fa fa-times"></a>
                                    </div>
                                </header>
                                <div class="content-body">    
                                    <div class="row align-items-center flex">
                                        <div class="col-xs-12">
                                            
                                            <div class="speciality-item relative">
                                                <div class="doc-img-con speciality pull-left">
                                                    <i class="fa fa-facebook-square fa-3x"></i>
                                                </div>
                                                <div class="designer-info">
                                                    <h6 class="msg-sender">Facebook URL</h6>
                                                    <small class="text-muted f-s-14">{{$data->facebook_url}}</small>
                                                </div>
                                            </div>
                                            <div class="speciality-item relative ">
                                                <div class="doc-img-con speciality pull-left">
                                                    <i class="fa fa-twitter-square fa-3x"></i>
                                                </div>
                                                <div class="designer-info">
                                                    <h6 class="msg-sender">Twitter URL</h6>
                                                    <small class="text-muted f-s-14">{{$data->twitter_url}}</small>
                                                </div>
                                            </div>
                                            <div class="speciality-item relative mb-0">
                                                <div class="doc-img-con speciality pull-left">
                                                    <i class="fa fa-google-plus-square fa-3x"></i>
                                                </div>
                                                <div class="designer-info">
                                                    <h6 class="msg-sender">Google Plus URL</h6>
                                                    <small class="text-muted f-s-14">{{$data->google_plus_url}}</small>
                                                </div>
                                            </div>
                                            
                                        </div>
                                    </div>
                                </div>
                            </section>
                        </div>
                    </div>
                </div>
                

                <div class="clearfix"></div>

                <div class="col-xs-12 col-md-6">
                    <section class="box ">
                        <header class="panel_header">
                            <h2 class="title pull-left">Recent Visits</h2>
                            <div class="actions panel_actions pull-right">
                                <a class="box_toggle fa fa-chevron-down"></a>
                                <a class="box_setting fa fa-cog" data-toggle="modal" href="#section-settings"></a>
                                <a class="box_close fa fa-times"></a>
                            </div>
                        </header>
                        <div class="content-body">    
                            <div class="row">
                                <div class="col-xs-12">
                                    <ul class="project-activity list-unstyled mb-0">
                                        <li class="activity-list warning">
                                            <div class="detail-info v2">
                                                <div class="doc-img-con pull-left mr-10">
                                                    <img src="../data/profile/avatar-2.png" width="80" alt="">
                                                </div>
                                                <div class="visit-doc">
                                                    <p class="message">
                                                         Mutten Sultan <span class="text-info bold">( Blood Check )</span>
                                                    </p>
                                                    <small class="text-muted">
                                                        Blood Check
                                                    </small>
                                                </div>
                                                <div class="visit-date pull-right">
                                                    <p class="mb-0">25 Nov</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="clearfix"></li>
                                        <li class="activity-list info">
                                            <div class="detail-info v2">
                                                <div class="doc-img-con pull-left mr-10">
                                                    <img src="../data/profile/avatar-3.png" width="80" alt="">
                                                </div>
                                                <div class="visit-doc">
                                                    <p class="message ">
                                                         Smith Watson <span class="text-info bold">( Medicine )</span>
                                                    </p>
                                                    <small class="text-muted">
                                                        Thryoid Test
                                                    </small>
                                                </div>
                                                <div class="visit-date pull-right">
                                                    <p class="mb-0">25 Nov</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list success">
                                            <div class="detail-info v2">
                                                <div class="doc-img-con pull-left mr-10">
                                                    <img src="../data/profile/avatar-4.png" width="80" alt="">
                                                </div>
                                                <div class="visit-doc">
                                                    <p class="message ">
                                                        Sarah Mutten <span class="text-info bold">( Pathology )</span>
                                                    </p>
                                                    <small class="text-muted">
                                                        Full Blood image
                                                    </small>
                                                </div>
                                                <div class="visit-date pull-right">
                                                    <p class="mb-0">25 Nov</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list success">
                                            <div class="detail-info v2">
                                                <div class="doc-img-con pull-left mr-10">
                                                    <img src="../data/profile/avatar-1.png" width="80" alt="">
                                                </div>
                                                <div class="visit-doc">
                                                    <p class="message ">
                                                        Shadow laoono <span class="text-info bold">( Medicine )</span>
                                                    </p>
                                                    <small class="text-muted">
                                                        Full Blood image
                                                    </small>
                                                </div>
                                                <div class="visit-date pull-right">
                                                    <p class="mb-0">25 Nov</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list danger">
                                            <div class="detail-info v2 pb0">
                                                <div class="doc-img-con pull-left mr-10">
                                                    <img src="../data/profile/avatar-5.png" width="80" alt="">
                                                </div>
                                                <div class="visit-doc">
                                                    <p class="message ">
                                                         Morese Sharpe <span class="text-info bold">( Routine Visit )</span>
                                                    </p>
                                                    <small class="text-muted">
                                                        Full Body Test
                                                    </small>
                                                </div>
                                                <div class="visit-date pull-right">
                                                    <p class="mb-0">25 Nov</p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>      
                            </div> <!-- End .row -->
                        </div>
                    </section>
                </div>

                <div class="col-xs-12 col-md-6">
                    
                    <section class="box ">
                        <header class="panel_header">
                            <h2 class="title pull-left">Patients Notes</h2>
                            <div class="actions panel_actions pull-right">
                                <a class="box_toggle fa fa-chevron-down"></a>
                                <a class="box_setting fa fa-cog" data-toggle="modal" href="#section-settings"></a>
                                <a class="box_close fa fa-times"></a>
                            </div>
                        </header>
                        <div class="content-body">    
                            <div class="row">
                                <div class="col-xs-12">
                                    <ul class="project-activity list-unstyled mb-0">
                                        <li class="activity-list warning">
                                            <div class="detail-info">
                                                <div class="visit-doc">
                                                    <small class="text-muted f-s-14 mb-7">
                                                        I feel better NowMutten Sultan
                                                    </small>
                                                    <p class="message">
                                                        Meditation
                                                    </p>
                                                    
                                                </div>
                                                <div class="visit-date visit-stat pull-right">
                                                    <p class="mb-0">OPEN</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="clearfix"></li>
                                        <li class="activity-list info">
                                            <div class="detail-info">
                                                <div class="visit-doc">
                                                    <small class="text-muted f-s-14 mb-7">
                                                        Treatment was good!
                                                    </small>
                                                    <p class="message">
                                                        Thyroid Test
                                                    </p>
                                                </div>
                                                <div class="visit-date visit-stat pull-right">
                                                    <p class="mb-0 uppercase">closed</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list success">
                                            <div class="detail-info">
                                                <div class="visit-doc">
                                                    <small class="text-muted f-s-14 mb-7">
                                                        My hair is gone!
                                                    </small>
                                                    <p class="message">
                                                        Unhappy
                                                    </p>
                                                </div>
                                                <div class="visit-date visit-stat pull-right">
                                                    <p class="mb-0 uppercase">open</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list warning">
                                            <div class="detail-info">
                                                <div class="visit-doc">
                                                    <small class="text-muted f-s-14 mb-7">
                                                        My hair is gone!
                                                    </small>
                                                    <p class="message">
                                                        Unhappy
                                                    </p>
                                                </div>
                                                <div class="visit-date visit-stat pull-right">
                                                    <p class="mb-0 uppercase">closed</p>
                                                </div>
                                            </div>
                                        </li>
                                        <li class="activity-list danger">
                                            <div class="detail-info pb0">
                                                <div class="visit-doc">
                                                    <small class="text-muted f-s-14 mb-7">
                                                        Mediacal Care is just a click away
                                                    </small>
                                                    <p class="message">
                                                        Join Pain
                                                    </p>
                                                </div>
                                                <div class="visit-date visit-stat pull-right">
                                                    <p class="mb-0 uppercase">open</p>
                                                </div>
                                            </div>
                                        </li>


                                    </ul>
                                </div>      
                            </div> <!-- End .row -->
                        </div>
                    </section>

                </div>

                <div class="clearfix"></div>


                <!-- MAIN CONTENT AREA ENDS -->
            </div>
            <div aria-hidden="true" role="dialog" tabindex="-1" id="myModal" class="modal fade" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                            <h4 class="modal-title">Assign Package</h4>
                        </div>
                        <div class="modal-body">
                             {!! Form::open(['role' => 'form','route' => "company.updatePackage",'method' => 'post', 'files' => true]) !!}
                            {{ Form::hidden('company_id','', ['class'=>'form-control company_id']) }}
                                <div class="form-group packageView">
                                   
                                </div>
                                
                               
                                <button type="submit" class="btn btn-primary">Submit</button>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
            
            <div aria-hidden="true" role="dialog" tabindex="-1" id="myVaccinationModal" class="modal fade" style="display: none;">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button aria-hidden="true" data-dismiss="modal" class="close" type="button">×</button>
                            <h4 class="modal-title">Assign Vaccination</h4>
                        </div>
                        <div class="modal-body">
                             {!! Form::open(['role' => 'form','route' => "company.updateVaccination",'method' => 'post', 'files' => true]) !!}
                            {{ Form::hidden('company_id','', ['class'=>'form-control company_id']) }}
                                <div class="form-group vaccinationView">
                                   
                                </div>
                                
                               
                                <button type="submit" class="btn btn-primary">Submit</button>
                            {!! Form::close() !!}
                        </div>
                    </div>
                </div>
            </div>
            <script>
                 function assignCompanyId(id){
                    $('.company_id').val(id);
                     $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                                
                    $('.packageView').empty();
                
                      
                
                        $.ajax({
                        type:'POST',
                        url:"{{ route('ajaxRequest.packageField') }}",
                        data:{company_id:id},
                        success:function(data){
                            //alert(data);

                            $('.packageView').empty().append(data);
                             $(".select2_demo_2").select2({
                                theme: 'bootstrap4',
                            });
                        }
                        });
               
           }
           
           
           function assignVaccinationCompanyId(id){
                    $('.company_id').val(id);
                     $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                        }
                    });
                                
                    $('.vaccinationView').empty();
                
                      
                
                        $.ajax({
                        type:'POST',
                        url:"{{ route('ajaxRequest.vaccinationField') }}",
                        data:{company_id:id},
                        success:function(data){
                            //alert(data);

                            $('.vaccinationView').empty().append(data);
                             $(".select2_demo_2").select2({
                                theme: 'bootstrap4',
                            });
                        }
                        });
               
           }
           
            </script>
@endsection
