@extends('admin.layouts.app')
@section('title', 'User Details')
@section('content')
<style>
    .filter-label {
        font-size: 14px;
        margin-right: 5px;
    }

    .filter-select {
        font-size: 14px;
        padding: 3px 6px;
    }
</style>
<div class="main-content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-body pt-30">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="mb-0">User Details</h4>
                                <span class="header-wallet-amount">
                                    
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <!-- User Information -->
                            <div class="col-md-6">
                                <h6>User Information</h6>
                                <ul class="list-group mt-4">
                                    <li class="list-group-item"><strong>Name :</strong> {{ $user->name }} {{ $user->lname }}</li>
                                    <li class="list-group-item"><strong>Email :</strong> {{ $user->email }}</li>
                                    <!-- Add more user details as needed -->
                                </ul>
                            </div>
                            <!-- Contact Information -->
                            <div class="col-md-6">
                                <h6>Contact Information</h6>
                                <ul class="list-group mt-4">
                                    <!--<li class="list-group-item"><strong>Address :</strong> {{ $user->address }}</li>-->
                                    <li class="list-group-item"><strong>Phone Number :</strong> {{ $user->phone_number }}</li>
                                    <!-- Add more contact details as needed -->
                                </ul>
                            </div>
                        </div>
                        <!-- Order History -->
                        <div class="card-body pt-30">
                            <div class="table-title d-flex justify-content-between">
                                <h5 class="mb-0">Order History</h5>
                            </div>
                            <div class="table-responsive">
                                <table class="text-nowrap bg-white dh-table">
                                    <thead>
                                        <tr>
                                            <th>Order ID</th>
                                            <th>Order Date</th>
                                            <th>Product</th>
                                            <th>Qty</th>
                                            <th>Customer name</th>
                                            <th>Total Amount (Rs)</th>
                                            <th>Payment Status</th>
                                            <th>Order Status</th>
                                            <!--<th>Action</th>-->
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse ($orders as $order)
                                            <tr>
                                                <td>{{ $order->order_number }}</td>
                                                <td>{{ $order->created_at->format('d M Y') }}</td>
                                                <td>
                                                    @foreach ($order->orderDetails as $orderDetail)
                                                        {{ $orderDetail->product ? Str::limit($orderDetail->product->name, 20, '...') : 'Product Not Found' }}
                                                        @unless ($loop->last)
                                                            <br>
                                                        @endunless
                                                    @endforeach
                                                </td>
                                                <td>
                                                    @foreach ($order->orderDetails as $orderDetail)
                                                        {{ $orderDetail->quantity }}
                                                        @unless ($loop->last)
                                                            <br>
                                                        @endunless
                                                    @endforeach
                                                </td>
                                                <td>{{ $order->user->name }} {{ $order->user->lname }}</td>
                                                <td>{{ $order->order_amount_after_discount }}</td>
                                                <td>{{ $order->payment_status ?: 'COD' }}</td>
                                                <td>{{ $order->order_status }}</td>
                                                {{--<td>
                                                    <a href="{{ route('orderDetails', $order->id) }}" title="View Invoice">View</a>
                                                </td>--}}
                                            </tr>
                                        @empty
                                            <tr>
                                                <td colspan="9"><center>No orders found!</center></td>
                                            </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
