@extends('front.layouts.app')
@section('title', 'My Address Book')
@section('content')
<style type="text/css">
    input {
        border: 1px solid #c4c4c4;
        padding: 5px 5px;
        border-radius: 5px;
        width: 100%;
    }

    .form-inner {
        padding: 50px 20px;
        box-shadow: 1px 1px 10px 1px #cac5c5;
    }

    i.fa.fa-plus {
        padding: 2px 6px;
        border: 1px solid grey;
        background: #d6a916;
        color: white;
    }
    .button-group {
        display: flex;
        justify-content: space-between;
    }
</style>

<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
    <div class="container color_dark">
        <a href="{{ route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">Add Address</span>
    </div>
</div>

<section>
    <div class="introduction dashboard">
        <div class="container">
            <div class="row">
                @include('front.customer.sidebar')

                <div class="col-lg-9">
                    <div class="account_content_area">
                        <h3 style="margin-bottom:15px;">My Address Book</h3>
                        <div class="light-bg default-box-shadow">
                            <div class="form-inner">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin:10px;">
                                        <a href="{{route('addNewAddress')}}" class="btn btn-success extrabt"><i class="fa fa-plus"></i> Add New Address</a>
                                    </div>
                                    @forelse ($customer_addresses as $customer_address)
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h5 class="card-title">{{ ucwords($customer_address->name) }} <small>({{ucwords($customer_address->address_type)}})</small></h5>
                                                <h6 class="card-title">Mobile <small><i class="fa fa-phone" style="vertical-align: middle;"></i> {{ $customer_address->mobile }}</small></h6>

                                                <p class="card-text">{{ $customer_address->address }}, {{ $customer_address->city_id }}, {{ $customer_address->state_id }}, {{ $customer_address->country_id }} - {{ $customer_address->pin_code }}</p>
                                                <div class="button-group">
                                                    <a href="{{route('editMyAddressBook',$customer_address->id)}}" class="btn btn-primary" style="color:blue;">Edit</a>
                                                    <form action="{{route('DeleteMyAddressBook', $customer_address->id)}}" method="post">
                                                        {{csrf_field()}}
                                                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure?')" style="color:red;">Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @empty
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <div class="card-body" style="padding-left:15px;">
                                            <p class="card-text">No Address found!</p>
                                        </div>
                                    </div>
                                    @endforelse
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
