@extends('front.layouts.app')
@section('title', 'Change Password')
@section('content') 
<style type="text/css">
    input {
        border: 1px solid #c4c4c4;
        padding: 5px 5px;
        border-radius: 5px;
        width: 100%;
    }

    .form-inner {
        padding: 50px 20px;
        box-shadow: 1px 1px 10px 1px #cac5c5;
    }
     .error-message {
        color: red;
        width: 100%; /* Ensure the error message takes up full width */
        display: block; /* Ensure each error message appears on a new line */
    }
    .alert-message {
        width: 93%;
        position: absolute;
        top: 20px;
        background-color: #d7f8e2; /* Reducing red color for alert */
        color: #721c24; /* Darkening text color for alert */
        padding: 15px;
        box-sizing: border-box;
        border-radius: 5px;
    }
</style>

<!-- page-title -->
<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container color_dark">
				<a href="{{ route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">Change password</span>          
				</div>
			</div>
<section> 
  
    <div class="introduction dashboard">
        <div class="container">
            <div class="row">
                @include('front.customer.sidebar')

                <div class="col col-lg-9">
                    <div class="account_content_area">
                        <div class="light-bg default-box-shadow">
                           <div class="form-inner">
                                <div class="card-body p-4">
                                    @if(Session::has('success'))
                                        <div class="alert-message" id="success-alert">
                                            {{ Session::get('success') }}
                                        </div>
                                    @endif
                                    @if(Session::has('error'))
                                        <div class="alert-message" id="error-alert">
                                            {{ Session::get('error') }}
                                        </div>
                                    @endif
                                </div>
                                <form action="{{ route('updateMyPassword') }}" method="post" id="contact-form" class="default-form" novalidate="novalidate">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                            <label for="acc-name">Current Password <span class="">*</span></label>
                                            <input type="password" name="old_password" placeholder="Current password"  aria-required="true" class="form-control @error('old_password') is-invalid @enderror">
                                            @error('old_password')
                                                <span class="invalid-feedback error-message" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                            <label for="acc-name">New Password <span class="">*</span></label>
                                            <input type="password" name="new_password" class="form-control  @error('new_password') is-invalid @enderror"  aria-required="true" placeholder="New Password">
                                            @error('new_password')
                                                <span class="invalid-feedback error-message" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                        
                                        <div class="col-lg-6 col-md-12 col-sm-12 form-group">
                                            <label for="acc-name">Confirm Password <span class="">*</span></label>
                                            <input class="form-control  @error('new_password_confirmation') is-invalid @enderror" type="password" name="new_password_confirmation" placeholder="Confirm New Password">
                                            @error('new_password_confirmation')
                                                <span class="invalid-feedback error-message" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>

                                        <div class="col-lg-12 col-md-12 col-sm-12 form-group message-btn left">
                                            <button type="submit" class="theme-btn-two update_details updatebt" name="submit-form">Update Now!<i class="flaticon-right-1"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> 
    <script>
    
    setTimeout(function() {
        document.getElementById('success-alert').style.display = 'none';
        document.getElementById('error-alert').style.display = 'none';
    }, 2000);
</script>
</section>

@endsection
