@extends('front.layouts.app')
@section('title','My Orders')
@section('content') 
        <!-- page-title -->

<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
				<div class="container color_dark">
					<a href="{{ route('homePage')}}" class="sc_hover">Home</a> / <span class="color_light">My Orders</span>
				</div>
			</div>
                <section> 
      <div class="page_section_offset">
				<div class="container">
					<div class="row order-list">
                         @include('front.customer.sidebar')

                     <section class="col-lg-12 col-md-12 col-sm-12 order_data">
							<h2 class="fw_light second_font color_dark m_bottom_27 tt_uppercase">Orders List</h2>
							<table class="w_full second_font orders_list_table">
                                    <thead class="bg_grey_light_2 d_xs_none">
                                        <tr>
                          
                           <th>Order ID</th>
                              <th>Order Date </th>
                               <th>Product </th>
                              <th>Qty</th>
                             <th>Customer name</th>
                             <th>Total Amount</th> 
                            <th>Payment Status </th>
                            <th>Order Status</th>
                             <th>Action</th>
                       
                                        </tr>
                                    </thead>
                                    <tbody>
                 @if (isset($orders) && count($orders) > 0)
                       @foreach ($orders as $recent_order)
                                       <tr>
                                          
                                           
                                        
                                            <td class="order-id">  {{ $recent_order->order_number }}   </td>
                                            <td class="diliver-date">  {{ $recent_order->created_at->format('d M Y') }}  </td>
                                          
                                          <td>
                                                @foreach($recent_order->orderDetails as $orderDetail)
                                                    @if ($orderDetail->product)
                                                        {{ Str::limit($orderDetail->product->name, 20, '...') }}
                                                    @else
                                                        Product Not Found
                                                    @endif
                                                    @if (!$loop->last)
                                                        ,</br> <!-- Add a comma if it's not the last product -->
                                                    @endif
                                                @endforeach
                                            </td>
                                          


                                            <td class="quantity">
                                                @foreach($recent_order->orderDetails as $orderDetail)
                                                    @if ($orderDetail->product)
                                                        {{ $orderDetail->quantity }} <!-- Display the quantity for the product -->
                                                    @else
                                                        Product Not Found
                                                    @endif
                                                    @if (!$loop->last)
                                                        , <!-- Add a comma if it's not the last product -->
                                                    @endif
                                                @endforeach
                                            </td>

                                            <td class="total"> <strong> {{ $recent_order->user_nsme }} </strong> </td> 
                                           
                                            <td class="total"> <strong> {{ $recent_order->order_amount_after_discount }} </strong> </td> 
                                             <td class="total"> <strong> @if(!empty($recent_order->payment_status)){{ $recent_order->payment_status }}@else
                                             COD @endif</strong> </td> 
                                              <td class="total"> <strong> {{ $recent_order->order_status }} </strong> </td>

                                        <td class="align-items-center" style="text-align: center;"> 
                                        <!--<a href="{{route('orderDetails',$recent_order->id)}}"><i class="fa fa-eye" title="View Order Details"> </i> </a>-->
                                     <a href="{{route('orderDetails',$recent_order->id)}}" title="view invoice"> View </a> </td>
                                             
                                        </tr>
                @endforeach
                @else
                 <tr><td colspan="10" ><center>No order found!</center></td></tr>
                @endif
                                       
                                       
                                    </tbody>                               
                                </table>
                            
                         
                        </section>


                        </div>
                    </div>
                </div>
            </div>
            </section>  
        @endsection