
<?php $__env->startSection('title', 'My Address Book'); ?>
<?php $__env->startSection('content'); ?>
<style type="text/css">
    input {
        border: 1px solid #c4c4c4;
        padding: 5px 5px;
        border-radius: 5px;
        width: 100%;
    }

    .form-inner {
        padding: 50px 20px;
        box-shadow: 1px 1px 10px 1px #cac5c5;
    }

    i.fa.fa-plus {
        padding: 2px 6px;
        border: 1px solid grey;
        background: #d6a916;
        color: white;
    }
    .button-group {
        display: flex;
        justify-content: space-between;
    }
</style>

<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
    <div class="container color_dark">
        <a href="<?php echo e(route('homePage')); ?>" class="sc_hover">Home</a> / <span class="color_light">Add Address</span>
    </div>
</div>

<section>
    <div class="introduction dashboard">
        <div class="container">
            <div class="row">
                <?php echo $__env->make('front.customer.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                <div class="col-lg-9">
                    <div class="account_content_area">
                        <h3 style="margin-bottom:15px;">My Address Book</h3>
                        <div class="light-bg default-box-shadow">
                            <div class="form-inner">
                                <div class="row">
                                    <div class="col-lg-12 col-md-12 col-sm-12" style="margin:10px;">
                                        <a href="<?php echo e(route('addNewAddress')); ?>" class="btn btn-success extrabt"><i class="fa fa-plus"></i> Add New Address</a>
                                    </div>
                                    <?php $__empty_1 = true; $__currentLoopData = $customer_addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer_address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <div class="card">
                                            <div class="card-body">
                                                <h5 class="card-title"><?php echo e(ucwords($customer_address->name)); ?> <small>(<?php echo e(ucwords($customer_address->address_type)); ?>)</small></h5>
                                                <h6 class="card-title">Mobile <small><i class="fa fa-phone" style="vertical-align: middle;"></i> <?php echo e($customer_address->mobile); ?></small></h6>

                                                <p class="card-text"><?php echo e($customer_address->address); ?>, <?php echo e($customer_address->city_id); ?>, <?php echo e($customer_address->state_id); ?>, <?php echo e($customer_address->country_id); ?> - <?php echo e($customer_address->pin_code); ?></p>
                                                <div class="button-group">
                                                    <a href="<?php echo e(route('editMyAddressBook',$customer_address->id)); ?>" class="btn btn-primary" style="color:blue;">Edit</a>
                                                    <form action="<?php echo e(route('DeleteMyAddressBook', $customer_address->id)); ?>" method="post">
                                                        <?php echo e(csrf_field()); ?>

                                                        <button type="submit" class="btn btn-danger" onclick="return confirm('Are you sure?')" style="color:red;">Delete</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <div class="col-lg-6 col-md-12 col-sm-12">
                                        <div class="card-body" style="padding-left:15px;">
                                            <p class="card-text">No Address found!</p>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/xgauheop/heckless.deuharmony.in/resources/views/front/customer/address-book/my-address-book.blade.php ENDPATH**/ ?>