

<?php $__env->startSection('content'); ?>
<div class="breadcrumbs bg_grey_light_2 fs_medium fw_light">
    <div class="container color_dark">
        <a href="<?php echo e(route('homePage')); ?>" class="sc_hover">Home</a> / <span class="color_light">Shopping Cart</span>
    </div>
</div>
<!--main content-->
<div class="page_section_offset">
    <div class="container numbered_title_init">
        <h2 class="fw_light second_font color_dark m_bottom_27 tt_uppercase">Shopping Cart</h2>
         <div id="loader" style="display: none;">Loading...</div>
        <?php if(count($cartItems) > 0): ?>
        <table class="w_full shopping_cart_table m_bottom_38 m_xs_bottom_30">
            <thead class="d_xs_none">
                <tr class="bg_grey_light_2 second_font">
                    <th><b>Product Image</b></th>
                    <th><b>Product Name</b></th>
                    <th><b>SKU</b></th>
                    <th><b>Price</b></th>
                    <th><b>Quantity</b></th>
                    <th><b>Total</b></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                <?php $total = 0; $shipping = 50; ?>
                <?php $__currentLoopData = $cartItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cartItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td data-cell-title="Product Image"><img src="<?php echo e(env('APP_URL')); ?><?php echo e($cartItem->product->front_image); ?>" class="w_full" alt=""></td>
                    <td data-cell-title="Product Name">
                        <a href="#" class="sc_hover second_font fs_large d_inline_b m_bottom_4"><?php echo e($cartItem->product->name); ?></a>
                        <ul class="fw_light fs_small lh_small color_light">
                            <li>Size: <span class="color_dark"><?php echo e($cartItem->productSizes->size->name); ?></span></li>
                        </ul>
                    </td>
                    <td data-cell-title="Price" class="second_font"><?php echo e($cartItem->product->sku_no); ?></td>
                    <td data-cell-title="SKU" class="second_font lh_small"><span class="color_dark">₹<?php echo e($cartItem->productSizes->sell_price); ?></span></td>
                  
                   
                     <td data-cell-title="Quantity">
                        
                        <div class="quantity clearfix t_align_c">
                            <button class="minus-btn" data-action="<?php echo e(route('decreaseCartItemQuantity', ['cart_id' => $cartItem->id])); ?>" <?php echo e($cartItem->quantity <= 1 ? 'disabled' : ''); ?>>-</button>
                            <input type="text" class="quantity-input" min="1" readonly value="<?php echo e($cartItem->quantity); ?>">
                            <button class="plus-btn" data-action="<?php echo e(route('increaseCartItemQuantity', ['cart_id' => $cartItem->id])); ?>">+</button>
                        </div>
                    </td>
                    <td data-cell-title="Total" class="second_font">
                        <b id="total-price-<?php echo e($cartItem->id); ?>" class="color_dark" data-sell-price="<?php echo e($cartItem->productSizes->sell_price); ?>">₹<?php echo e($cartItem->productSizes->sell_price * $cartItem->quantity); ?></b>
                    </td>

                    <td class="t_align_c">
                        <a class="button_type_8 black_hover grey state_2 m_xs_bottom_0 tr_all color_dark t_align_c vc_child m_bottom_5 remove remove-from-cart-btn" cart_id="<?php echo e($cartItem->id); ?>"><i class="fa fa-times fs_large d_inline_m"></i></a><br class="d_xs_none">
                    </td>
                </tr>
                <?php $total += $cartItem->productSizes->sell_price * $cartItem->quantity; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr class="bg_grey_light_2">
                    <td colspan="7">
                        <a href="<?php echo e(route('shoplisting','all')); ?>" class="button_type_2 d_block tt_uppercase fs_medium second_font f_left tr_all f_xs_none t_align_c m_xs_bottom_5 lbrown state_2"><span class="d_inline_b m_left_10 m_right_10">Continue Shopping</span></a>
                    </td>
                </tr>
            </tfoot>
        </table>

        <div class="row">
            <section class="col-lg-3 col-md3 col-sm-3 m_bottom_40 m_xs_bottom_30">
            </section>
            <section class="col-lg-5 col-md-5 col-sm-5 m_bottom_40 m_xs_bottom_30">
            </section>
            <section class="col-lg-4 col-md-4 col-sm-4 m_bottom_40 m_xs_bottom_30">
                <h5 class="color_dark tt_uppercase second_font fw_light m_bottom_13">Total</h5>
                <hr class="divider_bg m_bottom_25">
                <table class="w_full total_sc_table second_font type_2 t_xs_align_c">
                    <tbody>
                        <tr>
                            <td><b>Shopping Cost</b></td>
                            <td><b class="color_dark fs_large">₹<?php echo e($total); ?></b></td>
                        </tr>
                        <tr>
                            <td><b>Shipping</b></td>
                            <td><b class="color_dark fs_large">₹<?php echo e($shipping); ?></b></td>
                        </tr>
                        <tr class="scheme_color">
                            <td><b>Total</b></td>
                            <td><b class="fs_large">₹<?php echo e($total + $shipping); ?></b></td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr class="bg_grey_light_2 t_align_c">
                            <td colspan="2">
                                <?php if(!empty(Auth::user())): ?>
                                <a href="<?php echo e(route('checkout')); ?>" class="button_type_2 tt_uppercase fs_medium second_font tr_all lbrown d_block w_full m_top_10 m_bottom_15">Proceed to Checkout</a>
                                <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>" class="button_type_2 tt_uppercase fs_medium second_font tr_all lbrown d_block w_full m_top_10 m_bottom_15">Proceed to Checkout</a>
                                <?php endif; ?>
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </section>
        </div>
        <?php else: ?>
        <div>Empty Cart</div>
        <?php endif; ?>
    </div>
</div>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('front.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/sandman/public_html/resources/views/front/cart-details.blade.php ENDPATH**/ ?>